package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPRouteSpecFluentImpl<A extends HTTPRouteSpecFluent<A>> extends BaseFluent<A> implements HTTPRouteSpecFluent<A>{
  public HTTPRouteSpecFluentImpl() {
  }
  public HTTPRouteSpecFluentImpl(HTTPRouteSpec instance) {
    this.withHostnames(instance.getHostnames()); 
    this.withParentRefs(instance.getParentRefs()); 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> hostnames = new ArrayList<String>();
  private ArrayList<ParentReferenceBuilder> parentRefs = new ArrayList<ParentReferenceBuilder>();
  private ArrayList<HTTPRouteRuleBuilder> rules = new ArrayList<HTTPRouteRuleBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToHostnames(Integer index,String item) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    this.hostnames.add(index, item);
    return (A)this;
  }
  public A setToHostnames(Integer index,String item) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    this.hostnames.set(index, item); return (A)this;
  }
  public A addToHostnames(java.lang.String... items) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    for (String item : items) {this.hostnames.add(item);} return (A)this;
  }
  public A addAllToHostnames(Collection<String> items) {
    if (this.hostnames == null) {this.hostnames = new ArrayList<String>();}
    for (String item : items) {this.hostnames.add(item);} return (A)this;
  }
  public A removeFromHostnames(java.lang.String... items) {
    for (String item : items) {if (this.hostnames!= null){ this.hostnames.remove(item);}} return (A)this;
  }
  public A removeAllFromHostnames(Collection<String> items) {
    for (String item : items) {if (this.hostnames!= null){ this.hostnames.remove(item);}} return (A)this;
  }
  public List<String> getHostnames() {
    return this.hostnames;
  }
  public String getHostname(Integer index) {
    return this.hostnames.get(index);
  }
  public String getFirstHostname() {
    return this.hostnames.get(0);
  }
  public String getLastHostname() {
    return this.hostnames.get(hostnames.size() - 1);
  }
  public String getMatchingHostname(Predicate<String> predicate) {
    for (String item: hostnames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHostname(Predicate<String> predicate) {
    for (String item: hostnames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostnames(List<String> hostnames) {
    if (hostnames != null) {this.hostnames = new ArrayList(); for (String item : hostnames){this.addToHostnames(item);}} else { this.hostnames = null;} return (A) this;
  }
  public A withHostnames(java.lang.String... hostnames) {
    if (this.hostnames != null) {this.hostnames.clear();}
    if (hostnames != null) {for (String item :hostnames){ this.addToHostnames(item);}} return (A) this;
  }
  public Boolean hasHostnames() {
    return hostnames != null && !hostnames.isEmpty();
  }
  public A addToParentRefs(Integer index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(index >= 0 ? index : _visitables.get("parentRefs").size(), builder);this.parentRefs.add(index >= 0 ? index : parentRefs.size(), builder); return (A)this;
  }
  public A setToParentRefs(Integer index,ParentReference item) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    ParentReferenceBuilder builder = new ParentReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("parentRefs").size()) { _visitables.get("parentRefs").add(builder); } else { _visitables.get("parentRefs").set(index, builder);}
    if (index < 0 || index >= parentRefs.size()) { parentRefs.add(builder); } else { parentRefs.set(index, builder);}
     return (A)this;
  }
  public A addToParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference... items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(builder);this.parentRefs.add(builder);} return (A)this;
  }
  public A addAllToParentRefs(Collection<ParentReference> items) {
    if (this.parentRefs == null) {this.parentRefs = new ArrayList<ParentReferenceBuilder>();}
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").add(builder);this.parentRefs.add(builder);} return (A)this;
  }
  public A removeFromParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference... items) {
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").remove(builder);if (this.parentRefs != null) {this.parentRefs.remove(builder);}} return (A)this;
  }
  public A removeAllFromParentRefs(Collection<ParentReference> items) {
    for (ParentReference item : items) {ParentReferenceBuilder builder = new ParentReferenceBuilder(item);_visitables.get("parentRefs").remove(builder);if (this.parentRefs != null) {this.parentRefs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromParentRefs(Predicate<ParentReferenceBuilder> predicate) {
    if (parentRefs == null) return (A) this;
    final Iterator<ParentReferenceBuilder> each = parentRefs.iterator();
    final List visitables = _visitables.get("parentRefs");
    while (each.hasNext()) {
      ParentReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildParentRefs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ParentReference> getParentRefs() {
    return parentRefs != null ? build(parentRefs) : null;
  }
  public List<ParentReference> buildParentRefs() {
    return parentRefs != null ? build(parentRefs) : null;
  }
  public ParentReference buildParentRef(Integer index) {
    return this.parentRefs.get(index).build();
  }
  public ParentReference buildFirstParentRef() {
    return this.parentRefs.get(0).build();
  }
  public ParentReference buildLastParentRef() {
    return this.parentRefs.get(parentRefs.size() - 1).build();
  }
  public ParentReference buildMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    for (ParentReferenceBuilder item: parentRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    for (ParentReferenceBuilder item: parentRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withParentRefs(List<ParentReference> parentRefs) {
    if (this.parentRefs != null) { _visitables.get("parentRefs").removeAll(this.parentRefs);}
    if (parentRefs != null) {this.parentRefs = new ArrayList(); for (ParentReference item : parentRefs){this.addToParentRefs(item);}} else { this.parentRefs = null;} return (A) this;
  }
  public A withParentRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ParentReference... parentRefs) {
    if (this.parentRefs != null) {this.parentRefs.clear();}
    if (parentRefs != null) {for (ParentReference item :parentRefs){ this.addToParentRefs(item);}} return (A) this;
  }
  public Boolean hasParentRefs() {
    return parentRefs != null && !parentRefs.isEmpty();
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> addNewParentRef() {
    return new HTTPRouteSpecFluentImpl.ParentRefsNestedImpl();
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> addNewParentRefLike(ParentReference item) {
    return new HTTPRouteSpecFluentImpl.ParentRefsNestedImpl(-1, item);
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> setNewParentRefLike(Integer index,ParentReference item) {
    return new HTTPRouteSpecFluentImpl.ParentRefsNestedImpl(index, item);
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> editParentRef(Integer index) {
    if (parentRefs.size() <= index) throw new RuntimeException("Can't edit parentRefs. Index exceeds size.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> editFirstParentRef() {
    if (parentRefs.size() == 0) throw new RuntimeException("Can't edit first parentRefs. The list is empty.");
    return setNewParentRefLike(0, buildParentRef(0));
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> editLastParentRef() {
    int index = parentRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last parentRefs. The list is empty.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  public HTTPRouteSpecFluent.ParentRefsNested<A> editMatchingParentRef(Predicate<ParentReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<parentRefs.size();i++) { 
    if (predicate.test(parentRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching parentRefs. No match found.");
    return setNewParentRefLike(index, buildParentRef(index));
  }
  public A addToRules(Integer index,HTTPRouteRule item) {
    if (this.rules == null) {this.rules = new ArrayList<HTTPRouteRuleBuilder>();}
    HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
  }
  public A setToRules(Integer index,HTTPRouteRule item) {
    if (this.rules == null) {this.rules = new ArrayList<HTTPRouteRuleBuilder>();}
    HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
    if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
     return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<HTTPRouteRuleBuilder>();}
    for (HTTPRouteRule item : items) {HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<HTTPRouteRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<HTTPRouteRuleBuilder>();}
    for (HTTPRouteRule item : items) {HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteRule... items) {
    for (HTTPRouteRule item : items) {HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<HTTPRouteRule> items) {
    for (HTTPRouteRule item : items) {HTTPRouteRuleBuilder builder = new HTTPRouteRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<HTTPRouteRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<HTTPRouteRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      HTTPRouteRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HTTPRouteRule> getRules() {
    return rules != null ? build(rules) : null;
  }
  public List<HTTPRouteRule> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public HTTPRouteRule buildRule(Integer index) {
    return this.rules.get(index).build();
  }
  public HTTPRouteRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public HTTPRouteRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public HTTPRouteRule buildMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
    for (HTTPRouteRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
    for (HTTPRouteRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<HTTPRouteRule> rules) {
    if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
    if (rules != null) {this.rules = new ArrayList(); for (HTTPRouteRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteRule... rules) {
    if (this.rules != null) {this.rules.clear();}
    if (rules != null) {for (HTTPRouteRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public HTTPRouteSpecFluent.RulesNested<A> addNewRule() {
    return new HTTPRouteSpecFluentImpl.RulesNestedImpl();
  }
  public HTTPRouteSpecFluent.RulesNested<A> addNewRuleLike(HTTPRouteRule item) {
    return new HTTPRouteSpecFluentImpl.RulesNestedImpl(-1, item);
  }
  public HTTPRouteSpecFluent.RulesNested<A> setNewRuleLike(Integer index,HTTPRouteRule item) {
    return new HTTPRouteSpecFluentImpl.RulesNestedImpl(index, item);
  }
  public HTTPRouteSpecFluent.RulesNested<A> editRule(Integer index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public HTTPRouteSpecFluent.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public HTTPRouteSpecFluent.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public HTTPRouteSpecFluent.RulesNested<A> editMatchingRule(Predicate<HTTPRouteRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPRouteSpecFluentImpl that = (HTTPRouteSpecFluentImpl) o;
    if (hostnames != null ? !hostnames.equals(that.hostnames) :that.hostnames != null) return false;
    if (parentRefs != null ? !parentRefs.equals(that.parentRefs) :that.parentRefs != null) return false;
    if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hostnames,  parentRefs,  rules,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostnames != null && !hostnames.isEmpty()) { sb.append("hostnames:"); sb.append(hostnames + ","); }
    if (parentRefs != null && !parentRefs.isEmpty()) { sb.append("parentRefs:"); sb.append(parentRefs + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ParentRefsNestedImpl<N> extends ParentReferenceFluentImpl<HTTPRouteSpecFluent.ParentRefsNested<N>> implements HTTPRouteSpecFluent.ParentRefsNested<N>,Nested<N>{
    ParentRefsNestedImpl(Integer index,ParentReference item) {
      this.index = index;
      this.builder = new ParentReferenceBuilder(this, item);
    }
    ParentRefsNestedImpl() {
      this.index = -1;
      this.builder = new ParentReferenceBuilder(this);
    }
    ParentReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) HTTPRouteSpecFluentImpl.this.setToParentRefs(index,builder.build());
    }
    public N endParentRef() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends HTTPRouteRuleFluentImpl<HTTPRouteSpecFluent.RulesNested<N>> implements HTTPRouteSpecFluent.RulesNested<N>,Nested<N>{
    RulesNestedImpl(Integer index,HTTPRouteRule item) {
      this.index = index;
      this.builder = new HTTPRouteRuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new HTTPRouteRuleBuilder(this);
    }
    HTTPRouteRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) HTTPRouteSpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}