package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteStatusBuilder extends HTTPRouteStatusFluentImpl<HTTPRouteStatusBuilder> implements VisitableBuilder<HTTPRouteStatus,HTTPRouteStatusBuilder>{
  public HTTPRouteStatusBuilder() {
    this(false);
  }
  public HTTPRouteStatusBuilder(Boolean validationEnabled) {
    this(new HTTPRouteStatus(), validationEnabled);
  }
  public HTTPRouteStatusBuilder(HTTPRouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteStatusBuilder(HTTPRouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRouteStatus(), validationEnabled);
  }
  public HTTPRouteStatusBuilder(HTTPRouteStatusFluent<?> fluent,HTTPRouteStatus instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteStatusBuilder(HTTPRouteStatusFluent<?> fluent,HTTPRouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withParents(instance.getParents()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteStatusBuilder(HTTPRouteStatus instance) {
    this(instance,false);
  }
  public HTTPRouteStatusBuilder(HTTPRouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withParents(instance.getParents()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRouteStatus build() {
    HTTPRouteStatus buildable = new HTTPRouteStatus(fluent.getParents());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}