/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayTLSConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayTLSConfigFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.SecretObjectReference;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.SecretObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.SecretObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewayTLSConfigFluentImpl<A extends GatewayTLSConfigFluent<A>>
extends BaseFluent<A>
implements GatewayTLSConfigFluent<A> {
    private ArrayList<SecretObjectReferenceBuilder> certificateRefs = new ArrayList();
    private String mode;
    private Map<String, String> options;
    private Map<String, Object> additionalProperties;

    public GatewayTLSConfigFluentImpl() {
    }

    public GatewayTLSConfigFluentImpl(GatewayTLSConfig instance) {
        this.withCertificateRefs(instance.getCertificateRefs());
        this.withMode(instance.getMode());
        this.withOptions(instance.getOptions());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToCertificateRefs(Integer index, SecretObjectReference item) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
        this._visitables.get((Object)"certificateRefs").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"certificateRefs").size(), builder);
        this.certificateRefs.add(index >= 0 ? index.intValue() : this.certificateRefs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCertificateRefs(Integer index, SecretObjectReference item) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"certificateRefs").size()) {
            this._visitables.get((Object)"certificateRefs").add(builder);
        } else {
            this._visitables.get((Object)"certificateRefs").set(index, builder);
        }
        if (index < 0 || index >= this.certificateRefs.size()) {
            this.certificateRefs.add(builder);
        } else {
            this.certificateRefs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCertificateRefs(SecretObjectReference ... items) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get((Object)"certificateRefs").add(builder);
            this.certificateRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCertificateRefs(Collection<SecretObjectReference> items) {
        if (this.certificateRefs == null) {
            this.certificateRefs = new ArrayList();
        }
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get((Object)"certificateRefs").add(builder);
            this.certificateRefs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCertificateRefs(SecretObjectReference ... items) {
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get((Object)"certificateRefs").remove(builder);
            if (this.certificateRefs == null) continue;
            this.certificateRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCertificateRefs(Collection<SecretObjectReference> items) {
        for (SecretObjectReference item : items) {
            SecretObjectReferenceBuilder builder = new SecretObjectReferenceBuilder(item);
            this._visitables.get((Object)"certificateRefs").remove(builder);
            if (this.certificateRefs == null) continue;
            this.certificateRefs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCertificateRefs(Predicate<SecretObjectReferenceBuilder> predicate) {
        if (this.certificateRefs == null) {
            return (A)this;
        }
        Iterator<SecretObjectReferenceBuilder> each = this.certificateRefs.iterator();
        List visitables = this._visitables.get((Object)"certificateRefs");
        while (each.hasNext()) {
            SecretObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SecretObjectReference> getCertificateRefs() {
        return this.certificateRefs != null ? GatewayTLSConfigFluentImpl.build(this.certificateRefs) : null;
    }

    @Override
    public List<SecretObjectReference> buildCertificateRefs() {
        return this.certificateRefs != null ? GatewayTLSConfigFluentImpl.build(this.certificateRefs) : null;
    }

    @Override
    public SecretObjectReference buildCertificateRef(Integer index) {
        return this.certificateRefs.get(index).build();
    }

    @Override
    public SecretObjectReference buildFirstCertificateRef() {
        return this.certificateRefs.get(0).build();
    }

    @Override
    public SecretObjectReference buildLastCertificateRef() {
        return this.certificateRefs.get(this.certificateRefs.size() - 1).build();
    }

    @Override
    public SecretObjectReference buildMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
        for (SecretObjectReferenceBuilder item : this.certificateRefs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
        for (SecretObjectReferenceBuilder item : this.certificateRefs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCertificateRefs(List<SecretObjectReference> certificateRefs) {
        if (this.certificateRefs != null) {
            this._visitables.get((Object)"certificateRefs").removeAll(this.certificateRefs);
        }
        if (certificateRefs != null) {
            this.certificateRefs = new ArrayList();
            for (SecretObjectReference item : certificateRefs) {
                this.addToCertificateRefs(item);
            }
        } else {
            this.certificateRefs = null;
        }
        return (A)this;
    }

    @Override
    public A withCertificateRefs(SecretObjectReference ... certificateRefs) {
        if (this.certificateRefs != null) {
            this.certificateRefs.clear();
        }
        if (certificateRefs != null) {
            for (SecretObjectReference item : certificateRefs) {
                this.addToCertificateRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCertificateRefs() {
        return this.certificateRefs != null && !this.certificateRefs.isEmpty();
    }

    @Override
    public A addNewCertificateRef(String group, String kind, String name, String namespace) {
        return this.addToCertificateRefs(new SecretObjectReference(group, kind, name, namespace));
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> addNewCertificateRef() {
        return new CertificateRefsNestedImpl();
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> addNewCertificateRefLike(SecretObjectReference item) {
        return new CertificateRefsNestedImpl(-1, item);
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> setNewCertificateRefLike(Integer index, SecretObjectReference item) {
        return new CertificateRefsNestedImpl(index, item);
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> editCertificateRef(Integer index) {
        if (this.certificateRefs.size() <= index) {
            throw new RuntimeException("Can't edit certificateRefs. Index exceeds size.");
        }
        return this.setNewCertificateRefLike(index, this.buildCertificateRef(index));
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> editFirstCertificateRef() {
        if (this.certificateRefs.size() == 0) {
            throw new RuntimeException("Can't edit first certificateRefs. The list is empty.");
        }
        return this.setNewCertificateRefLike(0, this.buildCertificateRef(0));
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> editLastCertificateRef() {
        int index = this.certificateRefs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last certificateRefs. The list is empty.");
        }
        return this.setNewCertificateRefLike(index, this.buildCertificateRef(index));
    }

    @Override
    public GatewayTLSConfigFluent.CertificateRefsNested<A> editMatchingCertificateRef(Predicate<SecretObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.certificateRefs.size(); ++i) {
            if (!predicate.test(this.certificateRefs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching certificateRefs. No match found.");
        }
        return this.setNewCertificateRefLike(index, this.buildCertificateRef(index));
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public A withMode(String mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public <K, V> A withOptions(Map<String, String> options) {
        this.options = options == null ? null : new LinkedHashMap<String, String>(options);
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayTLSConfigFluentImpl that = (GatewayTLSConfigFluentImpl)o;
        if (this.certificateRefs != null ? !this.certificateRefs.equals(that.certificateRefs) : that.certificateRefs != null) {
            return false;
        }
        if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.certificateRefs, this.mode, this.options, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateRefs != null && !this.certificateRefs.isEmpty()) {
            sb.append("certificateRefs:");
            sb.append(this.certificateRefs + ",");
        }
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class CertificateRefsNestedImpl<N>
    extends SecretObjectReferenceFluentImpl<GatewayTLSConfigFluent.CertificateRefsNested<N>>
    implements GatewayTLSConfigFluent.CertificateRefsNested<N>,
    Nested<N> {
        SecretObjectReferenceBuilder builder;
        Integer index;

        CertificateRefsNestedImpl(Integer index, SecretObjectReference item) {
            this.index = index;
            this.builder = new SecretObjectReferenceBuilder(this, item);
        }

        CertificateRefsNestedImpl() {
            this.index = -1;
            this.builder = new SecretObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)GatewayTLSConfigFluentImpl.this.setToCertificateRefs(this.index, this.builder.build());
        }

        @Override
        public N endCertificateRef() {
            return this.and();
        }
    }
}

