package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPURLRewriteFilterBuilder extends HTTPURLRewriteFilterFluentImpl<HTTPURLRewriteFilterBuilder> implements VisitableBuilder<HTTPURLRewriteFilter,HTTPURLRewriteFilterBuilder>{
  public HTTPURLRewriteFilterBuilder() {
    this(false);
  }
  public HTTPURLRewriteFilterBuilder(Boolean validationEnabled) {
    this(new HTTPURLRewriteFilter(), validationEnabled);
  }
  public HTTPURLRewriteFilterBuilder(HTTPURLRewriteFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPURLRewriteFilterBuilder(HTTPURLRewriteFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPURLRewriteFilter(), validationEnabled);
  }
  public HTTPURLRewriteFilterBuilder(HTTPURLRewriteFilterFluent<?> fluent,HTTPURLRewriteFilter instance) {
    this(fluent, instance, false);
  }
  public HTTPURLRewriteFilterBuilder(HTTPURLRewriteFilterFluent<?> fluent,HTTPURLRewriteFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostname(instance.getHostname()); 
    fluent.withPath(instance.getPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPURLRewriteFilterBuilder(HTTPURLRewriteFilter instance) {
    this(instance,false);
  }
  public HTTPURLRewriteFilterBuilder(HTTPURLRewriteFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostname(instance.getHostname()); 
    this.withPath(instance.getPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPURLRewriteFilterFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPURLRewriteFilter build() {
    HTTPURLRewriteFilter buildable = new HTTPURLRewriteFilter(fluent.getHostname(),fluent.getPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}