package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GRPCRouteMatchFluentImpl<A extends GRPCRouteMatchFluent<A>> extends BaseFluent<A> implements GRPCRouteMatchFluent<A>{
  public GRPCRouteMatchFluentImpl() {
  }
  public GRPCRouteMatchFluentImpl(GRPCRouteMatch instance) {
    this.withHeaders(instance.getHeaders()); 
    this.withMethod(instance.getMethod()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<GRPCHeaderMatchBuilder> headers = new ArrayList<GRPCHeaderMatchBuilder>();
  private GRPCMethodMatchBuilder method;
  private Map<String,Object> additionalProperties;
  public A addToHeaders(Integer index,GRPCHeaderMatch item) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").add(index >= 0 ? index : _visitables.get("headers").size(), builder);this.headers.add(index >= 0 ? index : headers.size(), builder); return (A)this;
  }
  public A setToHeaders(Integer index,GRPCHeaderMatch item) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);
    if (index < 0 || index >= _visitables.get("headers").size()) { _visitables.get("headers").add(builder); } else { _visitables.get("headers").set(index, builder);}
    if (index < 0 || index >= headers.size()) { headers.add(builder); } else { headers.set(index, builder);}
     return (A)this;
  }
  public A addToHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch... items) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A addAllToHeaders(Collection<GRPCHeaderMatch> items) {
    if (this.headers == null) {this.headers = new ArrayList<GRPCHeaderMatchBuilder>();}
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A removeFromHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch... items) {
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
  }
  public A removeAllFromHeaders(Collection<GRPCHeaderMatch> items) {
    for (GRPCHeaderMatch item : items) {GRPCHeaderMatchBuilder builder = new GRPCHeaderMatchBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHeaders(Predicate<GRPCHeaderMatchBuilder> predicate) {
    if (headers == null) return (A) this;
    final Iterator<GRPCHeaderMatchBuilder> each = headers.iterator();
    final List visitables = _visitables.get("headers");
    while (each.hasNext()) {
      GRPCHeaderMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GRPCHeaderMatch> getHeaders() {
    return headers != null ? build(headers) : null;
  }
  public List<GRPCHeaderMatch> buildHeaders() {
    return headers != null ? build(headers) : null;
  }
  public GRPCHeaderMatch buildHeader(Integer index) {
    return this.headers.get(index).build();
  }
  public GRPCHeaderMatch buildFirstHeader() {
    return this.headers.get(0).build();
  }
  public GRPCHeaderMatch buildLastHeader() {
    return this.headers.get(headers.size() - 1).build();
  }
  public GRPCHeaderMatch buildMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
    for (GRPCHeaderMatchBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
    for (GRPCHeaderMatchBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHeaders(List<GRPCHeaderMatch> headers) {
    if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
    if (headers != null) {this.headers = new ArrayList(); for (GRPCHeaderMatch item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
  }
  public A withHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCHeaderMatch... headers) {
    if (this.headers != null) {this.headers.clear();}
    if (headers != null) {for (GRPCHeaderMatch item :headers){ this.addToHeaders(item);}} return (A) this;
  }
  public Boolean hasHeaders() {
    return headers != null && !headers.isEmpty();
  }
  public A addNewHeader(String name,String type,String value) {
    return (A)addToHeaders(new GRPCHeaderMatch(name, type, value));
  }
  public GRPCRouteMatchFluent.HeadersNested<A> addNewHeader() {
    return new GRPCRouteMatchFluentImpl.HeadersNestedImpl();
  }
  public GRPCRouteMatchFluent.HeadersNested<A> addNewHeaderLike(GRPCHeaderMatch item) {
    return new GRPCRouteMatchFluentImpl.HeadersNestedImpl(-1, item);
  }
  public GRPCRouteMatchFluent.HeadersNested<A> setNewHeaderLike(Integer index,GRPCHeaderMatch item) {
    return new GRPCRouteMatchFluentImpl.HeadersNestedImpl(index, item);
  }
  public GRPCRouteMatchFluent.HeadersNested<A> editHeader(Integer index) {
    if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public GRPCRouteMatchFluent.HeadersNested<A> editFirstHeader() {
    if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
    return setNewHeaderLike(0, buildHeader(0));
  }
  public GRPCRouteMatchFluent.HeadersNested<A> editLastHeader() {
    int index = headers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public GRPCRouteMatchFluent.HeadersNested<A> editMatchingHeader(Predicate<GRPCHeaderMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<headers.size();i++) { 
    if (predicate.test(headers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  /**
   * This method has been deprecated, please use method buildMethod instead.
   * @return The buildable object.
   */
  @Deprecated
  public GRPCMethodMatch getMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public GRPCMethodMatch buildMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public A withMethod(GRPCMethodMatch method) {
    _visitables.get("method").remove(this.method);
    if (method!=null){ this.method= new GRPCMethodMatchBuilder(method); _visitables.get("method").add(this.method);} else { this.method = null; _visitables.get("method").remove(this.method); } return (A) this;
  }
  public Boolean hasMethod() {
    return this.method != null;
  }
  public A withNewMethod(String method,String service,String type) {
    return (A)withMethod(new GRPCMethodMatch(method, service, type));
  }
  public GRPCRouteMatchFluent.MethodNested<A> withNewMethod() {
    return new GRPCRouteMatchFluentImpl.MethodNestedImpl();
  }
  public GRPCRouteMatchFluent.MethodNested<A> withNewMethodLike(GRPCMethodMatch item) {
    return new GRPCRouteMatchFluentImpl.MethodNestedImpl(item);
  }
  public GRPCRouteMatchFluent.MethodNested<A> editMethod() {
    return withNewMethodLike(getMethod());
  }
  public GRPCRouteMatchFluent.MethodNested<A> editOrNewMethod() {
    return withNewMethodLike(getMethod() != null ? getMethod(): new GRPCMethodMatchBuilder().build());
  }
  public GRPCRouteMatchFluent.MethodNested<A> editOrNewMethodLike(GRPCMethodMatch item) {
    return withNewMethodLike(getMethod() != null ? getMethod(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GRPCRouteMatchFluentImpl that = (GRPCRouteMatchFluentImpl) o;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (method != null ? !method.equals(that.method) :that.method != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(headers,  method,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class HeadersNestedImpl<N> extends GRPCHeaderMatchFluentImpl<GRPCRouteMatchFluent.HeadersNested<N>> implements GRPCRouteMatchFluent.HeadersNested<N>,Nested<N>{
    HeadersNestedImpl(Integer index,GRPCHeaderMatch item) {
      this.index = index;
      this.builder = new GRPCHeaderMatchBuilder(this, item);
    }
    HeadersNestedImpl() {
      this.index = -1;
      this.builder = new GRPCHeaderMatchBuilder(this);
    }
    GRPCHeaderMatchBuilder builder;
    Integer index;
    public N and() {
      return (N) GRPCRouteMatchFluentImpl.this.setToHeaders(index,builder.build());
    }
    public N endHeader() {
      return and();
    }
    
  }
  class MethodNestedImpl<N> extends GRPCMethodMatchFluentImpl<GRPCRouteMatchFluent.MethodNested<N>> implements GRPCRouteMatchFluent.MethodNested<N>,Nested<N>{
    MethodNestedImpl(GRPCMethodMatch item) {
      this.builder = new GRPCMethodMatchBuilder(this, item);
    }
    MethodNestedImpl() {
      this.builder = new GRPCMethodMatchBuilder(this);
    }
    GRPCMethodMatchBuilder builder;
    public N and() {
      return (N) GRPCRouteMatchFluentImpl.this.withMethod(builder.build());
    }
    public N endMethod() {
      return and();
    }
    
  }
  
}