package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCRouteRuleBuilder extends GRPCRouteRuleFluentImpl<GRPCRouteRuleBuilder> implements VisitableBuilder<GRPCRouteRule,GRPCRouteRuleBuilder>{
  public GRPCRouteRuleBuilder() {
    this(false);
  }
  public GRPCRouteRuleBuilder(Boolean validationEnabled) {
    this(new GRPCRouteRule(), validationEnabled);
  }
  public GRPCRouteRuleBuilder(GRPCRouteRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCRouteRuleBuilder(GRPCRouteRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCRouteRule(), validationEnabled);
  }
  public GRPCRouteRuleBuilder(GRPCRouteRuleFluent<?> fluent,GRPCRouteRule instance) {
    this(fluent, instance, false);
  }
  public GRPCRouteRuleBuilder(GRPCRouteRuleFluent<?> fluent,GRPCRouteRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackendRefs(instance.getBackendRefs()); 
    fluent.withFilters(instance.getFilters()); 
    fluent.withMatches(instance.getMatches()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GRPCRouteRuleBuilder(GRPCRouteRule instance) {
    this(instance,false);
  }
  public GRPCRouteRuleBuilder(GRPCRouteRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackendRefs(instance.getBackendRefs()); 
    this.withFilters(instance.getFilters()); 
    this.withMatches(instance.getMatches()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GRPCRouteRuleFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCRouteRule build() {
    GRPCRouteRule buildable = new GRPCRouteRule(fluent.getBackendRefs(),fluent.getFilters(),fluent.getMatches());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}