package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPRouteListBuilder extends TCPRouteListFluentImpl<TCPRouteListBuilder> implements VisitableBuilder<TCPRouteList,TCPRouteListBuilder>{
  public TCPRouteListBuilder() {
    this(false);
  }
  public TCPRouteListBuilder(Boolean validationEnabled) {
    this(new TCPRouteList(), validationEnabled);
  }
  public TCPRouteListBuilder(TCPRouteListFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPRouteListBuilder(TCPRouteListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPRouteList(), validationEnabled);
  }
  public TCPRouteListBuilder(TCPRouteListFluent<?> fluent,TCPRouteList instance) {
    this(fluent, instance, false);
  }
  public TCPRouteListBuilder(TCPRouteListFluent<?> fluent,TCPRouteList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TCPRouteListBuilder(TCPRouteList instance) {
    this(instance,false);
  }
  public TCPRouteListBuilder(TCPRouteList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TCPRouteListFluent<?> fluent;
  Boolean validationEnabled;
  public TCPRouteList build() {
    TCPRouteList buildable = new TCPRouteList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}