package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteStatusBuilder extends TLSRouteStatusFluentImpl<TLSRouteStatusBuilder> implements VisitableBuilder<TLSRouteStatus,TLSRouteStatusBuilder>{
  public TLSRouteStatusBuilder() {
    this(false);
  }
  public TLSRouteStatusBuilder(Boolean validationEnabled) {
    this(new TLSRouteStatus(), validationEnabled);
  }
  public TLSRouteStatusBuilder(TLSRouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteStatusBuilder(TLSRouteStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRouteStatus(), validationEnabled);
  }
  public TLSRouteStatusBuilder(TLSRouteStatusFluent<?> fluent,TLSRouteStatus instance) {
    this(fluent, instance, false);
  }
  public TLSRouteStatusBuilder(TLSRouteStatusFluent<?> fluent,TLSRouteStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withParents(instance.getParents());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteStatusBuilder(TLSRouteStatus instance) {
    this(instance,false);
  }
  public TLSRouteStatusBuilder(TLSRouteStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withParents(instance.getParents());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSRouteStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRouteStatus build() {
    TLSRouteStatus buildable = new TLSRouteStatus(fluent.getParents());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}