package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPRouteRuleFluentImpl<A extends HTTPRouteRuleFluent<A>> extends BaseFluent<A> implements HTTPRouteRuleFluent<A>{
  public HTTPRouteRuleFluentImpl() {
  }
  public HTTPRouteRuleFluentImpl(HTTPRouteRule instance) {
    if (instance != null) {
      this.withBackendRefs(instance.getBackendRefs());
      this.withFilters(instance.getFilters());
      this.withMatches(instance.getMatches());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<HTTPBackendRefBuilder> backendRefs = new ArrayList<HTTPBackendRefBuilder>();
  private ArrayList<HTTPRouteFilterBuilder> filters = new ArrayList<HTTPRouteFilterBuilder>();
  private ArrayList<HTTPRouteMatchBuilder> matches = new ArrayList<HTTPRouteMatchBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToBackendRefs(int index,HTTPBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
    if (index < 0 || index >= backendRefs.size()) { _visitables.get("backendRefs").add(builder); backendRefs.add(builder); } else { _visitables.get("backendRefs").add(index, builder); backendRefs.add(index, builder);}
    return (A)this;
  }
  public A setToBackendRefs(int index,HTTPBackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);
    if (index < 0 || index >= backendRefs.size()) { _visitables.get("backendRefs").add(builder); backendRefs.add(builder); } else { _visitables.get("backendRefs").set(index, builder); backendRefs.set(index, builder);}
    return (A)this;
  }
  public A addToBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPBackendRef... items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A addAllToBackendRefs(Collection<HTTPBackendRef> items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<HTTPBackendRefBuilder>();}
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A removeFromBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPBackendRef... items) {
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder);if (this.backendRefs != null) {this.backendRefs.remove(builder);}} return (A)this;
  }
  public A removeAllFromBackendRefs(Collection<HTTPBackendRef> items) {
    for (HTTPBackendRef item : items) {HTTPBackendRefBuilder builder = new HTTPBackendRefBuilder(item);_visitables.get("backendRefs").remove(builder);if (this.backendRefs != null) {this.backendRefs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBackendRefs(Predicate<HTTPBackendRefBuilder> predicate) {
    if (backendRefs == null) return (A) this;
    final Iterator<HTTPBackendRefBuilder> each = backendRefs.iterator();
    final List visitables = _visitables.get("backendRefs");
    while (each.hasNext()) {
      HTTPBackendRefBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBackendRefs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HTTPBackendRef> getBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public List<HTTPBackendRef> buildBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public HTTPBackendRef buildBackendRef(int index) {
    return this.backendRefs.get(index).build();
  }
  public HTTPBackendRef buildFirstBackendRef() {
    return this.backendRefs.get(0).build();
  }
  public HTTPBackendRef buildLastBackendRef() {
    return this.backendRefs.get(backendRefs.size() - 1).build();
  }
  public HTTPBackendRef buildMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
    for (HTTPBackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
    for (HTTPBackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBackendRefs(List<HTTPBackendRef> backendRefs) {
    if (this.backendRefs != null) { _visitables.get("backendRefs").clear();}
    if (backendRefs != null) {this.backendRefs = new ArrayList(); for (HTTPBackendRef item : backendRefs){this.addToBackendRefs(item);}} else { this.backendRefs = null;} return (A) this;
  }
  public A withBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPBackendRef... backendRefs) {
    if (this.backendRefs != null) {this.backendRefs.clear(); _visitables.remove("backendRefs"); }
    if (backendRefs != null) {for (HTTPBackendRef item :backendRefs){ this.addToBackendRefs(item);}} return (A) this;
  }
  public Boolean hasBackendRefs() {
    return backendRefs != null && !backendRefs.isEmpty();
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> addNewBackendRef() {
    return new HTTPRouteRuleFluentImpl.BackendRefsNestedImpl();
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> addNewBackendRefLike(HTTPBackendRef item) {
    return new HTTPRouteRuleFluentImpl.BackendRefsNestedImpl(-1, item);
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> setNewBackendRefLike(int index,HTTPBackendRef item) {
    return new HTTPRouteRuleFluentImpl.BackendRefsNestedImpl(index, item);
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> editBackendRef(int index) {
    if (backendRefs.size() <= index) throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> editFirstBackendRef() {
    if (backendRefs.size() == 0) throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
    return setNewBackendRefLike(0, buildBackendRef(0));
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> editLastBackendRef() {
    int index = backendRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public HTTPRouteRuleFluentImpl.BackendRefsNested<A> editMatchingBackendRef(Predicate<HTTPBackendRefBuilder> predicate) {
    int index = -1;
    for (int i=0;i<backendRefs.size();i++) { 
    if (predicate.test(backendRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching backendRefs. No match found.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public A addToFilters(int index,HTTPRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").add(index, builder); filters.add(index, builder);}
    return (A)this;
  }
  public A setToFilters(int index,HTTPRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").set(index, builder); filters.set(index, builder);}
    return (A)this;
  }
  public A addToFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A addAllToFilters(Collection<HTTPRouteFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<HTTPRouteFilterBuilder>();}
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A removeFromFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteFilter... items) {
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeAllFromFilters(Collection<HTTPRouteFilter> items) {
    for (HTTPRouteFilter item : items) {HTTPRouteFilterBuilder builder = new HTTPRouteFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFilters(Predicate<HTTPRouteFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<HTTPRouteFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      HTTPRouteFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFilters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HTTPRouteFilter> getFilters() {
    return filters != null ? build(filters) : null;
  }
  public List<HTTPRouteFilter> buildFilters() {
    return filters != null ? build(filters) : null;
  }
  public HTTPRouteFilter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  public HTTPRouteFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  public HTTPRouteFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  public HTTPRouteFilter buildMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
    for (HTTPRouteFilterBuilder item: filters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
    for (HTTPRouteFilterBuilder item: filters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFilters(List<HTTPRouteFilter> filters) {
    if (this.filters != null) { _visitables.get("filters").clear();}
    if (filters != null) {this.filters = new ArrayList(); for (HTTPRouteFilter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
  }
  public A withFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteFilter... filters) {
    if (this.filters != null) {this.filters.clear(); _visitables.remove("filters"); }
    if (filters != null) {for (HTTPRouteFilter item :filters){ this.addToFilters(item);}} return (A) this;
  }
  public Boolean hasFilters() {
    return filters != null && !filters.isEmpty();
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> addNewFilter() {
    return new HTTPRouteRuleFluentImpl.FiltersNestedImpl();
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> addNewFilterLike(HTTPRouteFilter item) {
    return new HTTPRouteRuleFluentImpl.FiltersNestedImpl(-1, item);
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> setNewFilterLike(int index,HTTPRouteFilter item) {
    return new HTTPRouteRuleFluentImpl.FiltersNestedImpl(index, item);
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public HTTPRouteRuleFluentImpl.FiltersNested<A> editMatchingFilter(Predicate<HTTPRouteFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public A addToMatches(int index,HTTPRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
    if (index < 0 || index >= matches.size()) { _visitables.get("matches").add(builder); matches.add(builder); } else { _visitables.get("matches").add(index, builder); matches.add(index, builder);}
    return (A)this;
  }
  public A setToMatches(int index,HTTPRouteMatch item) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);
    if (index < 0 || index >= matches.size()) { _visitables.get("matches").add(builder); matches.add(builder); } else { _visitables.get("matches").set(index, builder); matches.set(index, builder);}
    return (A)this;
  }
  public A addToMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatch... items) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  public A addAllToMatches(Collection<HTTPRouteMatch> items) {
    if (this.matches == null) {this.matches = new ArrayList<HTTPRouteMatchBuilder>();}
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").add(builder);this.matches.add(builder);} return (A)this;
  }
  public A removeFromMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatch... items) {
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").remove(builder);if (this.matches != null) {this.matches.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatches(Collection<HTTPRouteMatch> items) {
    for (HTTPRouteMatch item : items) {HTTPRouteMatchBuilder builder = new HTTPRouteMatchBuilder(item);_visitables.get("matches").remove(builder);if (this.matches != null) {this.matches.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatches(Predicate<HTTPRouteMatchBuilder> predicate) {
    if (matches == null) return (A) this;
    final Iterator<HTTPRouteMatchBuilder> each = matches.iterator();
    final List visitables = _visitables.get("matches");
    while (each.hasNext()) {
      HTTPRouteMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatches instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HTTPRouteMatch> getMatches() {
    return matches != null ? build(matches) : null;
  }
  public List<HTTPRouteMatch> buildMatches() {
    return matches != null ? build(matches) : null;
  }
  public HTTPRouteMatch buildMatch(int index) {
    return this.matches.get(index).build();
  }
  public HTTPRouteMatch buildFirstMatch() {
    return this.matches.get(0).build();
  }
  public HTTPRouteMatch buildLastMatch() {
    return this.matches.get(matches.size() - 1).build();
  }
  public HTTPRouteMatch buildMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
    for (HTTPRouteMatchBuilder item: matches) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
    for (HTTPRouteMatchBuilder item: matches) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatches(List<HTTPRouteMatch> matches) {
    if (this.matches != null) { _visitables.get("matches").clear();}
    if (matches != null) {this.matches = new ArrayList(); for (HTTPRouteMatch item : matches){this.addToMatches(item);}} else { this.matches = null;} return (A) this;
  }
  public A withMatches(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteMatch... matches) {
    if (this.matches != null) {this.matches.clear(); _visitables.remove("matches"); }
    if (matches != null) {for (HTTPRouteMatch item :matches){ this.addToMatches(item);}} return (A) this;
  }
  public Boolean hasMatches() {
    return matches != null && !matches.isEmpty();
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> addNewMatch() {
    return new HTTPRouteRuleFluentImpl.MatchesNestedImpl();
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> addNewMatchLike(HTTPRouteMatch item) {
    return new HTTPRouteRuleFluentImpl.MatchesNestedImpl(-1, item);
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> setNewMatchLike(int index,HTTPRouteMatch item) {
    return new HTTPRouteRuleFluentImpl.MatchesNestedImpl(index, item);
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> editMatch(int index) {
    if (matches.size() <= index) throw new RuntimeException("Can't edit matches. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> editFirstMatch() {
    if (matches.size() == 0) throw new RuntimeException("Can't edit first matches. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> editLastMatch() {
    int index = matches.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matches. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public HTTPRouteRuleFluentImpl.MatchesNested<A> editMatchingMatch(Predicate<HTTPRouteMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matches.size();i++) { 
    if (predicate.test(matches.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matches. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteRuleFluentImpl that = (HTTPRouteRuleFluentImpl) o;
    if (!java.util.Objects.equals(backendRefs, that.backendRefs)) return false;

    if (!java.util.Objects.equals(filters, that.filters)) return false;

    if (!java.util.Objects.equals(matches, that.matches)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backendRefs,  filters,  matches,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backendRefs != null) { sb.append("backendRefs:"); sb.append(backendRefs + ","); }
    if (filters != null) { sb.append("filters:"); sb.append(filters + ","); }
    if (matches != null) { sb.append("matches:"); sb.append(matches + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BackendRefsNestedImpl<N> extends HTTPBackendRefFluentImpl<HTTPRouteRuleFluentImpl.BackendRefsNested<N>> implements HTTPRouteRuleFluentImpl.BackendRefsNested<N>,Nested<N>{
    BackendRefsNestedImpl(int index,HTTPBackendRef item) {
      this.index = index;
      this.builder = new HTTPBackendRefBuilder(this, item);
    }
    BackendRefsNestedImpl() {
      this.index = -1;
      this.builder = new HTTPBackendRefBuilder(this);
    }
    HTTPBackendRefBuilder builder;
    int index;
    public N and() {
      return (N) HTTPRouteRuleFluentImpl.this.setToBackendRefs(index,builder.build());
    }
    public N endBackendRef() {
      return and();
    }
    
  }
  class FiltersNestedImpl<N> extends HTTPRouteFilterFluentImpl<HTTPRouteRuleFluentImpl.FiltersNested<N>> implements HTTPRouteRuleFluentImpl.FiltersNested<N>,Nested<N>{
    FiltersNestedImpl(int index,HTTPRouteFilter item) {
      this.index = index;
      this.builder = new HTTPRouteFilterBuilder(this, item);
    }
    FiltersNestedImpl() {
      this.index = -1;
      this.builder = new HTTPRouteFilterBuilder(this);
    }
    HTTPRouteFilterBuilder builder;
    int index;
    public N and() {
      return (N) HTTPRouteRuleFluentImpl.this.setToFilters(index,builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  class MatchesNestedImpl<N> extends HTTPRouteMatchFluentImpl<HTTPRouteRuleFluentImpl.MatchesNested<N>> implements HTTPRouteRuleFluentImpl.MatchesNested<N>,Nested<N>{
    MatchesNestedImpl(int index,HTTPRouteMatch item) {
      this.index = index;
      this.builder = new HTTPRouteMatchBuilder(this, item);
    }
    MatchesNestedImpl() {
      this.index = -1;
      this.builder = new HTTPRouteMatchBuilder(this);
    }
    HTTPRouteMatchBuilder builder;
    int index;
    public N and() {
      return (N) HTTPRouteRuleFluentImpl.this.setToMatches(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  
}