package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListenerStatusBuilder extends ListenerStatusFluentImpl<ListenerStatusBuilder> implements VisitableBuilder<ListenerStatus,ListenerStatusBuilder>{
  public ListenerStatusBuilder() {
    this(false);
  }
  public ListenerStatusBuilder(Boolean validationEnabled) {
    this(new ListenerStatus(), validationEnabled);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ListenerStatus(), validationEnabled);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance) {
    this(fluent, instance, false);
  }
  public ListenerStatusBuilder(ListenerStatusFluent<?> fluent,ListenerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAttachedRoutes(instance.getAttachedRoutes());
      fluent.withConditions(instance.getConditions());
      fluent.withName(instance.getName());
      fluent.withSupportedKinds(instance.getSupportedKinds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ListenerStatusBuilder(ListenerStatus instance) {
    this(instance,false);
  }
  public ListenerStatusBuilder(ListenerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAttachedRoutes(instance.getAttachedRoutes());
      this.withConditions(instance.getConditions());
      this.withName(instance.getName());
      this.withSupportedKinds(instance.getSupportedKinds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ListenerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ListenerStatus build() {
    ListenerStatus buildable = new ListenerStatus(fluent.getAttachedRoutes(),fluent.getConditions(),fluent.getName(),fluent.getSupportedKinds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}