package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteMatchBuilder extends HTTPRouteMatchFluentImpl<HTTPRouteMatchBuilder> implements VisitableBuilder<HTTPRouteMatch,HTTPRouteMatchBuilder>{
  public HTTPRouteMatchBuilder() {
    this(false);
  }
  public HTTPRouteMatchBuilder(Boolean validationEnabled) {
    this(new HTTPRouteMatch(), validationEnabled);
  }
  public HTTPRouteMatchBuilder(HTTPRouteMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteMatchBuilder(HTTPRouteMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRouteMatch(), validationEnabled);
  }
  public HTTPRouteMatchBuilder(HTTPRouteMatchFluent<?> fluent,HTTPRouteMatch instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteMatchBuilder(HTTPRouteMatchFluent<?> fluent,HTTPRouteMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHeaders(instance.getHeaders());
      fluent.withMethod(instance.getMethod());
      fluent.withPath(instance.getPath());
      fluent.withQueryParams(instance.getQueryParams());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteMatchBuilder(HTTPRouteMatch instance) {
    this(instance,false);
  }
  public HTTPRouteMatchBuilder(HTTPRouteMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHeaders(instance.getHeaders());
      this.withMethod(instance.getMethod());
      this.withPath(instance.getPath());
      this.withQueryParams(instance.getQueryParams());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteMatchFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRouteMatch build() {
    HTTPRouteMatch buildable = new HTTPRouteMatch(fluent.getHeaders(),fluent.getMethod(),fluent.getPath(),fluent.getQueryParams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}