package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayAddressBuilder extends GatewayAddressFluent<GatewayAddressBuilder> implements VisitableBuilder<GatewayAddress,GatewayAddressBuilder>{
  public GatewayAddressBuilder() {
    this(false);
  }
  public GatewayAddressBuilder(Boolean validationEnabled) {
    this(new GatewayAddress(), validationEnabled);
  }
  public GatewayAddressBuilder(GatewayAddressFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayAddressBuilder(GatewayAddressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayAddress(), validationEnabled);
  }
  public GatewayAddressBuilder(GatewayAddressFluent<?> fluent,GatewayAddress instance) {
    this(fluent, instance, false);
  }
  public GatewayAddressBuilder(GatewayAddressFluent<?> fluent,GatewayAddress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GatewayAddress());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GatewayAddressBuilder(GatewayAddress instance) {
    this(instance,false);
  }
  public GatewayAddressBuilder(GatewayAddress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GatewayAddress());

    if (instance != null) {
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GatewayAddressFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayAddress build() {
    GatewayAddress buildable = new GatewayAddress(fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}