package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPPathMatchBuilder extends HTTPPathMatchFluent<HTTPPathMatchBuilder> implements VisitableBuilder<HTTPPathMatch,HTTPPathMatchBuilder>{
  public HTTPPathMatchBuilder() {
    this(false);
  }
  public HTTPPathMatchBuilder(Boolean validationEnabled) {
    this(new HTTPPathMatch(), validationEnabled);
  }
  public HTTPPathMatchBuilder(HTTPPathMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPPathMatchBuilder(HTTPPathMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPPathMatch(), validationEnabled);
  }
  public HTTPPathMatchBuilder(HTTPPathMatchFluent<?> fluent,HTTPPathMatch instance) {
    this(fluent, instance, false);
  }
  public HTTPPathMatchBuilder(HTTPPathMatchFluent<?> fluent,HTTPPathMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPPathMatch());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPPathMatchBuilder(HTTPPathMatch instance) {
    this(instance,false);
  }
  public HTTPPathMatchBuilder(HTTPPathMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPPathMatch());

    if (instance != null) {
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPPathMatchFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPPathMatch build() {
    HTTPPathMatch buildable = new HTTPPathMatch(fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}