package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReferenceGrantSpecBuilder extends ReferenceGrantSpecFluent<ReferenceGrantSpecBuilder> implements VisitableBuilder<ReferenceGrantSpec,ReferenceGrantSpecBuilder>{
  public ReferenceGrantSpecBuilder() {
    this(false);
  }
  public ReferenceGrantSpecBuilder(Boolean validationEnabled) {
    this(new ReferenceGrantSpec(), validationEnabled);
  }
  public ReferenceGrantSpecBuilder(ReferenceGrantSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReferenceGrantSpecBuilder(ReferenceGrantSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReferenceGrantSpec(), validationEnabled);
  }
  public ReferenceGrantSpecBuilder(ReferenceGrantSpecFluent<?> fluent,ReferenceGrantSpec instance) {
    this(fluent, instance, false);
  }
  public ReferenceGrantSpecBuilder(ReferenceGrantSpecFluent<?> fluent,ReferenceGrantSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReferenceGrantSpec());

    if (instance != null) {
      fluent.withFrom(instance.getFrom());
      fluent.withTo(instance.getTo());
      fluent.withFrom(instance.getFrom());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReferenceGrantSpecBuilder(ReferenceGrantSpec instance) {
    this(instance,false);
  }
  public ReferenceGrantSpecBuilder(ReferenceGrantSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReferenceGrantSpec());

    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withTo(instance.getTo());
      this.withFrom(instance.getFrom());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReferenceGrantSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ReferenceGrantSpec build() {
    ReferenceGrantSpec buildable = new ReferenceGrantSpec(fluent.buildFrom(),fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}