package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRouteMatchFluent<A extends HTTPRouteMatchFluent<A>> extends BaseFluent<A>{
  public HTTPRouteMatchFluent() {
  }
  
  public HTTPRouteMatchFluent(HTTPRouteMatch instance) {
    this.copyInstance(instance);
  }
  private ArrayList<HTTPHeaderMatchBuilder> headers = new ArrayList<HTTPHeaderMatchBuilder>();
  private String method;
  private HTTPPathMatchBuilder path;
  private ArrayList<HTTPQueryParamMatchBuilder> queryParams = new ArrayList<HTTPQueryParamMatchBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRouteMatch instance) {
    instance = (instance != null ? instance : new HTTPRouteMatch());
    if (instance != null) {
          this.withHeaders(instance.getHeaders());
          this.withMethod(instance.getMethod());
          this.withPath(instance.getPath());
          this.withQueryParams(instance.getQueryParams());
          this.withHeaders(instance.getHeaders());
          this.withMethod(instance.getMethod());
          this.withPath(instance.getPath());
          this.withQueryParams(instance.getQueryParams());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToHeaders(int index,HTTPHeaderMatch item) {
    if (this.headers == null) {this.headers = new ArrayList<HTTPHeaderMatchBuilder>();}
    HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
    if (index < 0 || index >= headers.size()) { _visitables.get("headers").add(builder); headers.add(builder); } else { _visitables.get("headers").add(index, builder); headers.add(index, builder);}
    return (A)this;
  }
  
  public A setToHeaders(int index,HTTPHeaderMatch item) {
    if (this.headers == null) {this.headers = new ArrayList<HTTPHeaderMatchBuilder>();}
    HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);
    if (index < 0 || index >= headers.size()) { _visitables.get("headers").add(builder); headers.add(builder); } else { _visitables.get("headers").set(index, builder); headers.set(index, builder);}
    return (A)this;
  }
  
  public A addToHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPHeaderMatch... items) {
    if (this.headers == null) {this.headers = new ArrayList<HTTPHeaderMatchBuilder>();}
    for (HTTPHeaderMatch item : items) {HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  
  public A addAllToHeaders(Collection<HTTPHeaderMatch> items) {
    if (this.headers == null) {this.headers = new ArrayList<HTTPHeaderMatchBuilder>();}
    for (HTTPHeaderMatch item : items) {HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  
  public A removeFromHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPHeaderMatch... items) {
    if (this.headers == null) return (A)this;
    for (HTTPHeaderMatch item : items) {HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);_visitables.get("headers").remove(builder); this.headers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHeaders(Collection<HTTPHeaderMatch> items) {
    if (this.headers == null) return (A)this;
    for (HTTPHeaderMatch item : items) {HTTPHeaderMatchBuilder builder = new HTTPHeaderMatchBuilder(item);_visitables.get("headers").remove(builder); this.headers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHeaders(Predicate<HTTPHeaderMatchBuilder> predicate) {
    if (headers == null) return (A) this;
    final Iterator<HTTPHeaderMatchBuilder> each = headers.iterator();
    final List visitables = _visitables.get("headers");
    while (each.hasNext()) {
      HTTPHeaderMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPHeaderMatch> buildHeaders() {
    return this.headers != null ? build(headers) : null;
  }
  
  public HTTPHeaderMatch buildHeader(int index) {
    return this.headers.get(index).build();
  }
  
  public HTTPHeaderMatch buildFirstHeader() {
    return this.headers.get(0).build();
  }
  
  public HTTPHeaderMatch buildLastHeader() {
    return this.headers.get(headers.size() - 1).build();
  }
  
  public HTTPHeaderMatch buildMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
      for (HTTPHeaderMatchBuilder item : headers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
      for (HTTPHeaderMatchBuilder item : headers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHeaders(List<HTTPHeaderMatch> headers) {
    if (this.headers != null) {
      this._visitables.get("headers").clear();
    }
    if (headers != null) {
        this.headers = new ArrayList();
        for (HTTPHeaderMatch item : headers) {
          this.addToHeaders(item);
        }
    } else {
      this.headers = null;
    }
    return (A) this;
  }
  
  public A withHeaders(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPHeaderMatch... headers) {
    if (this.headers != null) {this.headers.clear(); _visitables.remove("headers"); }
    if (headers != null) {for (HTTPHeaderMatch item :headers){ this.addToHeaders(item);}} return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null && !this.headers.isEmpty();
  }
  
  public A addNewHeader(String name,String type,String value) {
    return (A)addToHeaders(new HTTPHeaderMatch(name, type, value));
  }
  
  public HeadersNested<A> addNewHeader() {
    return new HeadersNested(-1, null);
  }
  
  public HeadersNested<A> addNewHeaderLike(HTTPHeaderMatch item) {
    return new HeadersNested(-1, item);
  }
  
  public HeadersNested<A> setNewHeaderLike(int index,HTTPHeaderMatch item) {
    return new HeadersNested(index, item);
  }
  
  public HeadersNested<A> editHeader(int index) {
    if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  public HeadersNested<A> editFirstHeader() {
    if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
    return setNewHeaderLike(0, buildHeader(0));
  }
  
  public HeadersNested<A> editLastHeader() {
    int index = headers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  public HeadersNested<A> editMatchingHeader(Predicate<HTTPHeaderMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<headers.size();i++) { 
    if (predicate.test(headers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  public String getMethod() {
    return this.method;
  }
  
  public A withMethod(String method) {
    this.method = method;
    return (A) this;
  }
  
  public boolean hasMethod() {
    return this.method != null;
  }
  
  public HTTPPathMatch buildPath() {
    return this.path != null ? this.path.build() : null;
  }
  
  public A withPath(HTTPPathMatch path) {
    this._visitables.remove(this.path);
    if (path != null) {
        this.path = new HTTPPathMatchBuilder(path);
        this._visitables.get("path").add(this.path);
    } else {
        this.path = null;
        this._visitables.get("path").remove(this.path);
    }
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public A withNewPath(String type,String value) {
    return (A)withPath(new HTTPPathMatch(type, value));
  }
  
  public PathNested<A> withNewPath() {
    return new PathNested(null);
  }
  
  public PathNested<A> withNewPathLike(HTTPPathMatch item) {
    return new PathNested(item);
  }
  
  public PathNested<A> editPath() {
    return withNewPathLike(java.util.Optional.ofNullable(buildPath()).orElse(null));
  }
  
  public PathNested<A> editOrNewPath() {
    return withNewPathLike(java.util.Optional.ofNullable(buildPath()).orElse(new HTTPPathMatchBuilder().build()));
  }
  
  public PathNested<A> editOrNewPathLike(HTTPPathMatch item) {
    return withNewPathLike(java.util.Optional.ofNullable(buildPath()).orElse(item));
  }
  
  public A addToQueryParams(int index,HTTPQueryParamMatch item) {
    if (this.queryParams == null) {this.queryParams = new ArrayList<HTTPQueryParamMatchBuilder>();}
    HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
    if (index < 0 || index >= queryParams.size()) { _visitables.get("queryParams").add(builder); queryParams.add(builder); } else { _visitables.get("queryParams").add(index, builder); queryParams.add(index, builder);}
    return (A)this;
  }
  
  public A setToQueryParams(int index,HTTPQueryParamMatch item) {
    if (this.queryParams == null) {this.queryParams = new ArrayList<HTTPQueryParamMatchBuilder>();}
    HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);
    if (index < 0 || index >= queryParams.size()) { _visitables.get("queryParams").add(builder); queryParams.add(builder); } else { _visitables.get("queryParams").set(index, builder); queryParams.set(index, builder);}
    return (A)this;
  }
  
  public A addToQueryParams(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPQueryParamMatch... items) {
    if (this.queryParams == null) {this.queryParams = new ArrayList<HTTPQueryParamMatchBuilder>();}
    for (HTTPQueryParamMatch item : items) {HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);_visitables.get("queryParams").add(builder);this.queryParams.add(builder);} return (A)this;
  }
  
  public A addAllToQueryParams(Collection<HTTPQueryParamMatch> items) {
    if (this.queryParams == null) {this.queryParams = new ArrayList<HTTPQueryParamMatchBuilder>();}
    for (HTTPQueryParamMatch item : items) {HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);_visitables.get("queryParams").add(builder);this.queryParams.add(builder);} return (A)this;
  }
  
  public A removeFromQueryParams(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPQueryParamMatch... items) {
    if (this.queryParams == null) return (A)this;
    for (HTTPQueryParamMatch item : items) {HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);_visitables.get("queryParams").remove(builder); this.queryParams.remove(builder);} return (A)this;
  }
  
  public A removeAllFromQueryParams(Collection<HTTPQueryParamMatch> items) {
    if (this.queryParams == null) return (A)this;
    for (HTTPQueryParamMatch item : items) {HTTPQueryParamMatchBuilder builder = new HTTPQueryParamMatchBuilder(item);_visitables.get("queryParams").remove(builder); this.queryParams.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromQueryParams(Predicate<HTTPQueryParamMatchBuilder> predicate) {
    if (queryParams == null) return (A) this;
    final Iterator<HTTPQueryParamMatchBuilder> each = queryParams.iterator();
    final List visitables = _visitables.get("queryParams");
    while (each.hasNext()) {
      HTTPQueryParamMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPQueryParamMatch> buildQueryParams() {
    return this.queryParams != null ? build(queryParams) : null;
  }
  
  public HTTPQueryParamMatch buildQueryParam(int index) {
    return this.queryParams.get(index).build();
  }
  
  public HTTPQueryParamMatch buildFirstQueryParam() {
    return this.queryParams.get(0).build();
  }
  
  public HTTPQueryParamMatch buildLastQueryParam() {
    return this.queryParams.get(queryParams.size() - 1).build();
  }
  
  public HTTPQueryParamMatch buildMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
      for (HTTPQueryParamMatchBuilder item : queryParams) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
      for (HTTPQueryParamMatchBuilder item : queryParams) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withQueryParams(List<HTTPQueryParamMatch> queryParams) {
    if (this.queryParams != null) {
      this._visitables.get("queryParams").clear();
    }
    if (queryParams != null) {
        this.queryParams = new ArrayList();
        for (HTTPQueryParamMatch item : queryParams) {
          this.addToQueryParams(item);
        }
    } else {
      this.queryParams = null;
    }
    return (A) this;
  }
  
  public A withQueryParams(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPQueryParamMatch... queryParams) {
    if (this.queryParams != null) {this.queryParams.clear(); _visitables.remove("queryParams"); }
    if (queryParams != null) {for (HTTPQueryParamMatch item :queryParams){ this.addToQueryParams(item);}} return (A) this;
  }
  
  public boolean hasQueryParams() {
    return this.queryParams != null && !this.queryParams.isEmpty();
  }
  
  public A addNewQueryParam(String name,String type,String value) {
    return (A)addToQueryParams(new HTTPQueryParamMatch(name, type, value));
  }
  
  public QueryParamsNested<A> addNewQueryParam() {
    return new QueryParamsNested(-1, null);
  }
  
  public QueryParamsNested<A> addNewQueryParamLike(HTTPQueryParamMatch item) {
    return new QueryParamsNested(-1, item);
  }
  
  public QueryParamsNested<A> setNewQueryParamLike(int index,HTTPQueryParamMatch item) {
    return new QueryParamsNested(index, item);
  }
  
  public QueryParamsNested<A> editQueryParam(int index) {
    if (queryParams.size() <= index) throw new RuntimeException("Can't edit queryParams. Index exceeds size.");
    return setNewQueryParamLike(index, buildQueryParam(index));
  }
  
  public QueryParamsNested<A> editFirstQueryParam() {
    if (queryParams.size() == 0) throw new RuntimeException("Can't edit first queryParams. The list is empty.");
    return setNewQueryParamLike(0, buildQueryParam(0));
  }
  
  public QueryParamsNested<A> editLastQueryParam() {
    int index = queryParams.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last queryParams. The list is empty.");
    return setNewQueryParamLike(index, buildQueryParam(index));
  }
  
  public QueryParamsNested<A> editMatchingQueryParam(Predicate<HTTPQueryParamMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<queryParams.size();i++) { 
    if (predicate.test(queryParams.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching queryParams. No match found.");
    return setNewQueryParamLike(index, buildQueryParam(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteMatchFluent that = (HTTPRouteMatchFluent) o;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(method, that.method)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(queryParams, that.queryParams)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(headers,  method,  path,  queryParams,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (queryParams != null && !queryParams.isEmpty()) { sb.append("queryParams:"); sb.append(queryParams + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HeadersNested<N> extends HTTPHeaderMatchFluent<HeadersNested<N>> implements Nested<N>{
    HeadersNested(int index,HTTPHeaderMatch item) {
      this.index = index;
      this.builder = new HTTPHeaderMatchBuilder(this, item);
    }
    HTTPHeaderMatchBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPRouteMatchFluent.this.setToHeaders(index,builder.build());
    }
    
    public N endHeader() {
      return and();
    }
    
  
  }
  public class PathNested<N> extends HTTPPathMatchFluent<PathNested<N>> implements Nested<N>{
    PathNested(HTTPPathMatch item) {
      this.builder = new HTTPPathMatchBuilder(this, item);
    }
    HTTPPathMatchBuilder builder;
    
    public N and() {
      return (N) HTTPRouteMatchFluent.this.withPath(builder.build());
    }
    
    public N endPath() {
      return and();
    }
    
  
  }
  public class QueryParamsNested<N> extends HTTPQueryParamMatchFluent<QueryParamsNested<N>> implements Nested<N>{
    QueryParamsNested(int index,HTTPQueryParamMatch item) {
      this.index = index;
      this.builder = new HTTPQueryParamMatchBuilder(this, item);
    }
    HTTPQueryParamMatchBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPRouteMatchFluent.this.setToQueryParams(index,builder.build());
    }
    
    public N endQueryParam() {
      return and();
    }
    
  
  }

}