package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ListenerBuilder extends ListenerFluent<ListenerBuilder> implements VisitableBuilder<Listener,ListenerBuilder>{
  public ListenerBuilder() {
    this(new Listener());
  }
  
  public ListenerBuilder(ListenerFluent<?> fluent) {
    this(fluent, new Listener());
  }
  
  public ListenerBuilder(ListenerFluent<?> fluent,Listener instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ListenerBuilder(Listener instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ListenerFluent<?> fluent;
  
  public Listener build() {
    Listener buildable = new Listener(fluent.buildAllowedRoutes(),fluent.getHostname(),fluent.getName(),fluent.getPort(),fluent.getProtocol(),fluent.buildTls());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}