package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistence;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.SessionPersistenceFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BackendLBPolicySpecFluent<A extends BackendLBPolicySpecFluent<A>> extends BaseFluent<A>{
  public BackendLBPolicySpecFluent() {
  }
  
  public BackendLBPolicySpecFluent(BackendLBPolicySpec instance) {
    this.copyInstance(instance);
  }
  private SessionPersistenceBuilder sessionPersistence;
  private ArrayList<LocalPolicyTargetReferenceBuilder> targetRefs = new ArrayList<LocalPolicyTargetReferenceBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BackendLBPolicySpec instance) {
    instance = (instance != null ? instance : new BackendLBPolicySpec());
    if (instance != null) {
          this.withSessionPersistence(instance.getSessionPersistence());
          this.withTargetRefs(instance.getTargetRefs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SessionPersistence buildSessionPersistence() {
    return this.sessionPersistence != null ? this.sessionPersistence.build() : null;
  }
  
  public A withSessionPersistence(SessionPersistence sessionPersistence) {
    this._visitables.remove("sessionPersistence");
    if (sessionPersistence != null) {
        this.sessionPersistence = new SessionPersistenceBuilder(sessionPersistence);
        this._visitables.get("sessionPersistence").add(this.sessionPersistence);
    } else {
        this.sessionPersistence = null;
        this._visitables.get("sessionPersistence").remove(this.sessionPersistence);
    }
    return (A) this;
  }
  
  public boolean hasSessionPersistence() {
    return this.sessionPersistence != null;
  }
  
  public SessionPersistenceNested<A> withNewSessionPersistence() {
    return new SessionPersistenceNested(null);
  }
  
  public SessionPersistenceNested<A> withNewSessionPersistenceLike(SessionPersistence item) {
    return new SessionPersistenceNested(item);
  }
  
  public SessionPersistenceNested<A> editSessionPersistence() {
    return withNewSessionPersistenceLike(java.util.Optional.ofNullable(buildSessionPersistence()).orElse(null));
  }
  
  public SessionPersistenceNested<A> editOrNewSessionPersistence() {
    return withNewSessionPersistenceLike(java.util.Optional.ofNullable(buildSessionPersistence()).orElse(new SessionPersistenceBuilder().build()));
  }
  
  public SessionPersistenceNested<A> editOrNewSessionPersistenceLike(SessionPersistence item) {
    return withNewSessionPersistenceLike(java.util.Optional.ofNullable(buildSessionPersistence()).orElse(item));
  }
  
  public A addToTargetRefs(int index,LocalPolicyTargetReference item) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceBuilder>();}
    LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
    if (index < 0 || index >= targetRefs.size()) {
        _visitables.get("targetRefs").add(builder);
        targetRefs.add(builder);
    } else {
        _visitables.get("targetRefs").add(builder);
        targetRefs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToTargetRefs(int index,LocalPolicyTargetReference item) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceBuilder>();}
    LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);
    if (index < 0 || index >= targetRefs.size()) {
        _visitables.get("targetRefs").add(builder);
        targetRefs.add(builder);
    } else {
        _visitables.get("targetRefs").add(builder);
        targetRefs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToTargetRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReference... items) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceBuilder>();}
    for (LocalPolicyTargetReference item : items) {LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);_visitables.get("targetRefs").add(builder);this.targetRefs.add(builder);} return (A)this;
  }
  
  public A addAllToTargetRefs(Collection<LocalPolicyTargetReference> items) {
    if (this.targetRefs == null) {this.targetRefs = new ArrayList<LocalPolicyTargetReferenceBuilder>();}
    for (LocalPolicyTargetReference item : items) {LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);_visitables.get("targetRefs").add(builder);this.targetRefs.add(builder);} return (A)this;
  }
  
  public A removeFromTargetRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReference... items) {
    if (this.targetRefs == null) return (A)this;
    for (LocalPolicyTargetReference item : items) {LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);_visitables.get("targetRefs").remove(builder); this.targetRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTargetRefs(Collection<LocalPolicyTargetReference> items) {
    if (this.targetRefs == null) return (A)this;
    for (LocalPolicyTargetReference item : items) {LocalPolicyTargetReferenceBuilder builder = new LocalPolicyTargetReferenceBuilder(item);_visitables.get("targetRefs").remove(builder); this.targetRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTargetRefs(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
    if (targetRefs == null) return (A) this;
    final Iterator<LocalPolicyTargetReferenceBuilder> each = targetRefs.iterator();
    final List visitables = _visitables.get("targetRefs");
    while (each.hasNext()) {
      LocalPolicyTargetReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalPolicyTargetReference> buildTargetRefs() {
    return this.targetRefs != null ? build(targetRefs) : null;
  }
  
  public LocalPolicyTargetReference buildTargetRef(int index) {
    return this.targetRefs.get(index).build();
  }
  
  public LocalPolicyTargetReference buildFirstTargetRef() {
    return this.targetRefs.get(0).build();
  }
  
  public LocalPolicyTargetReference buildLastTargetRef() {
    return this.targetRefs.get(targetRefs.size() - 1).build();
  }
  
  public LocalPolicyTargetReference buildMatchingTargetRef(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
      for (LocalPolicyTargetReferenceBuilder item : targetRefs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTargetRef(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
      for (LocalPolicyTargetReferenceBuilder item : targetRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTargetRefs(List<LocalPolicyTargetReference> targetRefs) {
    if (this.targetRefs != null) {
      this._visitables.get("targetRefs").clear();
    }
    if (targetRefs != null) {
        this.targetRefs = new ArrayList();
        for (LocalPolicyTargetReference item : targetRefs) {
          this.addToTargetRefs(item);
        }
    } else {
      this.targetRefs = null;
    }
    return (A) this;
  }
  
  public A withTargetRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.LocalPolicyTargetReference... targetRefs) {
    if (this.targetRefs != null) {
        this.targetRefs.clear();
        _visitables.remove("targetRefs");
    }
    if (targetRefs != null) {
      for (LocalPolicyTargetReference item : targetRefs) {
        this.addToTargetRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTargetRefs() {
    return this.targetRefs != null && !this.targetRefs.isEmpty();
  }
  
  public A addNewTargetRef(String group,String kind,String name) {
    return (A)addToTargetRefs(new LocalPolicyTargetReference(group, kind, name));
  }
  
  public TargetRefsNested<A> addNewTargetRef() {
    return new TargetRefsNested(-1, null);
  }
  
  public TargetRefsNested<A> addNewTargetRefLike(LocalPolicyTargetReference item) {
    return new TargetRefsNested(-1, item);
  }
  
  public TargetRefsNested<A> setNewTargetRefLike(int index,LocalPolicyTargetReference item) {
    return new TargetRefsNested(index, item);
  }
  
  public TargetRefsNested<A> editTargetRef(int index) {
    if (targetRefs.size() <= index) throw new RuntimeException("Can't edit targetRefs. Index exceeds size.");
    return setNewTargetRefLike(index, buildTargetRef(index));
  }
  
  public TargetRefsNested<A> editFirstTargetRef() {
    if (targetRefs.size() == 0) throw new RuntimeException("Can't edit first targetRefs. The list is empty.");
    return setNewTargetRefLike(0, buildTargetRef(0));
  }
  
  public TargetRefsNested<A> editLastTargetRef() {
    int index = targetRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last targetRefs. The list is empty.");
    return setNewTargetRefLike(index, buildTargetRef(index));
  }
  
  public TargetRefsNested<A> editMatchingTargetRef(Predicate<LocalPolicyTargetReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<targetRefs.size();i++) { 
    if (predicate.test(targetRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching targetRefs. No match found.");
    return setNewTargetRefLike(index, buildTargetRef(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackendLBPolicySpecFluent that = (BackendLBPolicySpecFluent) o;
    if (!java.util.Objects.equals(sessionPersistence, that.sessionPersistence)) return false;
    if (!java.util.Objects.equals(targetRefs, that.targetRefs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(sessionPersistence,  targetRefs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (sessionPersistence != null) { sb.append("sessionPersistence:"); sb.append(sessionPersistence + ","); }
    if (targetRefs != null && !targetRefs.isEmpty()) { sb.append("targetRefs:"); sb.append(targetRefs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SessionPersistenceNested<N> extends SessionPersistenceFluent<SessionPersistenceNested<N>> implements Nested<N>{
    SessionPersistenceNested(SessionPersistence item) {
      this.builder = new SessionPersistenceBuilder(this, item);
    }
    SessionPersistenceBuilder builder;
    
    public N and() {
      return (N) BackendLBPolicySpecFluent.this.withSessionPersistence(builder.build());
    }
    
    public N endSessionPersistence() {
      return and();
    }
    
  
  }
  public class TargetRefsNested<N> extends LocalPolicyTargetReferenceFluent<TargetRefsNested<N>> implements Nested<N>{
    TargetRefsNested(int index,LocalPolicyTargetReference item) {
      this.index = index;
      this.builder = new LocalPolicyTargetReferenceBuilder(this, item);
    }
    LocalPolicyTargetReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) BackendLBPolicySpecFluent.this.setToTargetRefs(index,builder.build());
    }
    
    public N endTargetRef() {
      return and();
    }
    
  
  }

}