package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NodeMetricsFluent<A extends NodeMetricsFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public NodeMetricsFluent.MetadataNested<A> withNewMetadata();
    public NodeMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public NodeMetricsFluent.MetadataNested<A> editMetadata();
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadata();
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getTimestamp();
    public A withTimestamp(String timestamp);
    public Boolean hasTimestamp();
    public A withNewTimestamp(String arg1);
    public A withNewTimestamp(StringBuilder arg1);
    public A withNewTimestamp(StringBuffer arg1);
    public A addToUsage(String key,Quantity value);
    public A addToUsage(Map<String,Quantity> map);
    public A removeFromUsage(String key);
    public A removeFromUsage(Map<String,Quantity> map);
    public Map<String,Quantity> getUsage();
    public A withUsage(Map<String,Quantity> usage);
    public Boolean hasUsage();
    public Duration getWindow();
    public A withWindow(Duration window);
    public Boolean hasWindow();
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<NodeMetricsFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


}
