package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodeMetricsListBuilder extends NodeMetricsListFluentImpl<NodeMetricsListBuilder> implements VisitableBuilder<NodeMetricsList,NodeMetricsListBuilder> {

    NodeMetricsListFluent<?> fluent;
    Boolean validationEnabled;

    public NodeMetricsListBuilder() { 
        this(true);
    }


    public NodeMetricsListBuilder(Boolean validationEnabled) { 
        this(new NodeMetricsList(), validationEnabled);
    }


    public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent) { 
        this(fluent, true);
    }


    public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new NodeMetricsList(), validationEnabled);
    }


    public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent,NodeMetricsList instance) { 
        this(fluent, instance, true);
    }


    public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent,NodeMetricsList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public NodeMetricsListBuilder(NodeMetricsList instance) { 
        this(instance,true);
    }


    public NodeMetricsListBuilder(NodeMetricsList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public NodeMetricsList build() {
        NodeMetricsList buildable = new NodeMetricsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodeMetricsListBuilder that = (NodeMetricsListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
