package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface NodeMetricsListFluent<A extends NodeMetricsListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,NodeMetrics item);
    public A setToItems(int index,NodeMetrics item);
    public A addToItems(NodeMetrics... items);
    public A addAllToItems(Collection<NodeMetrics> items);
    public A removeFromItems(NodeMetrics... items);
    public A removeAllFromItems(Collection<NodeMetrics> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<NodeMetricsBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<NodeMetrics> getItems();
    public List<NodeMetrics> buildItems();
    public NodeMetrics buildItem(int index);
    public NodeMetrics buildFirstItem();
    public NodeMetrics buildLastItem();
    public NodeMetrics buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<NodeMetricsBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<NodeMetricsBuilder> predicate);
    public A withItems(List<NodeMetrics> items);
    public A withItems(NodeMetrics... items);
    public Boolean hasItems();
    public NodeMetricsListFluent.ItemsNested<A> addNewItem();
    public NodeMetricsListFluent.ItemsNested<A> addNewItemLike(NodeMetrics item);
    public NodeMetricsListFluent.ItemsNested<A> setNewItemLike(int index,NodeMetrics item);
    public NodeMetricsListFluent.ItemsNested<A> editItem(int index);
    public NodeMetricsListFluent.ItemsNested<A> editFirstItem();
    public NodeMetricsListFluent.ItemsNested<A> editLastItem();
    public NodeMetricsListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<NodeMetricsBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeMetricsFluent<NodeMetricsListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
