package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodMetricsListFluent<A extends PodMetricsListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,PodMetrics item);
    public A setToItems(int index,PodMetrics item);
    public A addToItems(PodMetrics... items);
    public A addAllToItems(Collection<PodMetrics> items);
    public A removeFromItems(PodMetrics... items);
    public A removeAllFromItems(Collection<PodMetrics> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<PodMetricsBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PodMetrics> getItems();
    public List<PodMetrics> buildItems();
    public PodMetrics buildItem(int index);
    public PodMetrics buildFirstItem();
    public PodMetrics buildLastItem();
    public PodMetrics buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PodMetricsBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PodMetricsBuilder> predicate);
    public A withItems(List<PodMetrics> items);
    public A withItems(PodMetrics... items);
    public Boolean hasItems();
    public PodMetricsListFluent.ItemsNested<A> addNewItem();
    public PodMetricsListFluent.ItemsNested<A> addNewItemLike(PodMetrics item);
    public PodMetricsListFluent.ItemsNested<A> setNewItemLike(int index,PodMetrics item);
    public PodMetricsListFluent.ItemsNested<A> editItem(int index);
    public PodMetricsListFluent.ItemsNested<A> editFirstItem();
    public PodMetricsListFluent.ItemsNested<A> editLastItem();
    public PodMetricsListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PodMetricsBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodMetricsFluent<PodMetricsListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
