package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerMetricsBuilder extends io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluentImpl<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder> {

    io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerMetricsBuilder() {
        this(true);
    }

    public ContainerMetricsBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerMetrics(), validationEnabled);
    }

    public ContainerMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerMetrics(), validationEnabled);
    }

    public ContainerMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent<?> fluent,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics instance) {
        this(fluent, instance, true);
    }

    public ContainerMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent<?> fluent,io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withUsage(instance.getUsage()); 
        this.validationEnabled = validationEnabled; 
    }

    public ContainerMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics instance) {
        this(instance,true);
    }

    public ContainerMetricsBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withUsage(instance.getUsage()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics build() {
        ContainerMetrics buildable = new ContainerMetrics(fluent.getName(),fluent.getUsage());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerMetricsBuilder that = (ContainerMetricsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
