package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodMetricsListBuilder extends io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListFluentImpl<io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList,io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListBuilder> {

    io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodMetricsListBuilder() {
        this(true);
    }

    public PodMetricsListBuilder(java.lang.Boolean validationEnabled) {
        this(new PodMetricsList(), validationEnabled);
    }

    public PodMetricsListBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListFluent<?> fluent) {
        this(fluent, true);
    }

    public PodMetricsListBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodMetricsList(), validationEnabled);
    }

    public PodMetricsListBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListFluent<?> fluent,io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList instance) {
        this(fluent, instance, true);
    }

    public PodMetricsListBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsListFluent<?> fluent,io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodMetricsListBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList instance) {
        this(instance,true);
    }

    public PodMetricsListBuilder(io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetricsList build() {
        PodMetricsList buildable = new PodMetricsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodMetricsListBuilder that = (PodMetricsListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
