package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodMetricsBuilder extends PodMetricsFluentImpl<PodMetricsBuilder> implements VisitableBuilder<PodMetrics,PodMetricsBuilder>{
  public PodMetricsBuilder() {
    this(false);
  }
  public PodMetricsBuilder(Boolean validationEnabled) {
    this(new PodMetrics(), validationEnabled);
  }
  public PodMetricsBuilder(PodMetricsFluent<?> fluent) {
    this(fluent, false);
  }
  public PodMetricsBuilder(PodMetricsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodMetrics(), validationEnabled);
  }
  public PodMetricsBuilder(PodMetricsFluent<?> fluent,PodMetrics instance) {
    this(fluent, instance, false);
  }
  public PodMetricsBuilder(PodMetricsFluent<?> fluent,PodMetrics instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withContainers(instance.getContainers()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withTimestamp(instance.getTimestamp()); 
    fluent.withWindow(instance.getWindow()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodMetricsBuilder(PodMetrics instance) {
    this(instance,false);
  }
  public PodMetricsBuilder(PodMetrics instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withContainers(instance.getContainers()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTimestamp(instance.getTimestamp()); 
    this.withWindow(instance.getWindow()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodMetricsFluent<?> fluent;
  Boolean validationEnabled;
  public PodMetrics build() {
    PodMetrics buildable = new PodMetrics(fluent.getApiVersion(),fluent.getContainers(),fluent.getKind(),fluent.getMetadata(),fluent.getTimestamp(),fluent.getWindow());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}