package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeMetricsListBuilder extends NodeMetricsListFluentImpl<NodeMetricsListBuilder> implements VisitableBuilder<NodeMetricsList,NodeMetricsListBuilder>{
  public NodeMetricsListBuilder() {
    this(false);
  }
  public NodeMetricsListBuilder(Boolean validationEnabled) {
    this(new NodeMetricsList(), validationEnabled);
  }
  public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeMetricsList(), validationEnabled);
  }
  public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent,NodeMetricsList instance) {
    this(fluent, instance, false);
  }
  public NodeMetricsListBuilder(NodeMetricsListFluent<?> fluent,NodeMetricsList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeMetricsListBuilder(NodeMetricsList instance) {
    this(instance,false);
  }
  public NodeMetricsListBuilder(NodeMetricsList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NodeMetricsListFluent<?> fluent;
  Boolean validationEnabled;
  public NodeMetricsList build() {
    NodeMetricsList buildable = new NodeMetricsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}