package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeMetricsBuilder extends NodeMetricsFluent<NodeMetricsBuilder> implements VisitableBuilder<NodeMetrics,NodeMetricsBuilder>{
  public NodeMetricsBuilder() {
    this(false);
  }
  public NodeMetricsBuilder(Boolean validationEnabled) {
    this(new NodeMetrics(), validationEnabled);
  }
  public NodeMetricsBuilder(NodeMetricsFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeMetrics(), validationEnabled);
  }
  public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,NodeMetrics instance) {
    this(fluent, instance, false);
  }
  public NodeMetricsBuilder(NodeMetricsFluent<?> fluent,NodeMetrics instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeMetrics());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTimestamp(instance.getTimestamp());
      fluent.withUsage(instance.getUsage());
      fluent.withWindow(instance.getWindow());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTimestamp(instance.getTimestamp());
      fluent.withUsage(instance.getUsage());
      fluent.withWindow(instance.getWindow());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeMetricsBuilder(NodeMetrics instance) {
    this(instance,false);
  }
  public NodeMetricsBuilder(NodeMetrics instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeMetrics());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTimestamp(instance.getTimestamp());
      this.withUsage(instance.getUsage());
      this.withWindow(instance.getWindow());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTimestamp(instance.getTimestamp());
      this.withUsage(instance.getUsage());
      this.withWindow(instance.getWindow());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeMetricsFluent<?> fluent;
  Boolean validationEnabled;
  public NodeMetrics build() {
    NodeMetrics buildable = new NodeMetrics(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.getTimestamp(),fluent.getUsage(),fluent.getWindow());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}