/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerFluent;
import io.fabric8.kubernetes.api.model.networking.NetworkPolicyPeerFluentImpl;

public class NetworkPolicyPeerBuilder
extends NetworkPolicyPeerFluentImpl<NetworkPolicyPeerBuilder>
implements VisitableBuilder<NetworkPolicyPeer, NetworkPolicyPeerBuilder> {
    NetworkPolicyPeerFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyPeerBuilder() {
        this(true);
    }

    public NetworkPolicyPeerBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, NetworkPolicyPeer instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, NetworkPolicyPeer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIpBlock(instance.getIpBlock());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withPodSelector(instance.getPodSelector());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIpBlock(instance.getIpBlock());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodSelector(instance.getPodSelector());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPeer build() {
        NetworkPolicyPeer buildable = new NetworkPolicyPeer(this.fluent.getIpBlock(), this.fluent.getNamespaceSelector(), this.fluent.getPodSelector());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPeerBuilder that = (NetworkPolicyPeerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

