package io.fabric8.kubernetes.api.model.networking.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressBackendFluent<A> {

    private TypedLocalObjectReference resource;
    private IngressServiceBackendBuilder service;

    public IngressBackendFluentImpl() { 
    }


    public IngressBackendFluentImpl(IngressBackend instance) { 
        this.withResource(instance.getResource()); 
        this.withService(instance.getService()); 
    }


    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public A withResource(TypedLocalObjectReference resource) {
        this.resource=resource; return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String apiGroup,String kind,String name) {
        return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public IngressServiceBackend getService() {
        return this.service!=null?this.service.build():null;
    }

    public IngressServiceBackend buildService() {
        return this.service!=null?this.service.build():null;
    }

    public A withService(IngressServiceBackend service) {
        _visitables.get("service").remove(this.service);
        if (service!=null){ this.service= new IngressServiceBackendBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public Boolean hasService() {
        return this.service != null;
    }

    public IngressBackendFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    public IngressBackendFluent.ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
        return new ServiceNestedImpl(item);
    }

    public IngressBackendFluent.ServiceNested<A> editService() {
        return withNewServiceLike(getService());
    }

    public IngressBackendFluent.ServiceNested<A> editOrNewService() {
        return withNewServiceLike(getService() != null ? getService(): new IngressServiceBackendBuilder().build());
    }

    public IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
        return withNewServiceLike(getService() != null ? getService(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (service != null ? !service.equals(that.service) :that.service != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resource,  service,  super.hashCode());
    }

    public class ServiceNestedImpl<N> extends IngressServiceBackendFluentImpl<IngressBackendFluent.ServiceNested<N>> implements IngressBackendFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressServiceBackendBuilder builder;

        ServiceNestedImpl(IngressServiceBackend item) {
            this.builder = new IngressServiceBackendBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new IngressServiceBackendBuilder(this);
        }

        public N and() {
             return (N) IngressBackendFluentImpl.this.withService(builder.build());
        }

        public N endService() {
             return and();
        }
    }


}
