package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class IngressRuleBuilder extends io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.IngressRule,io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder>{
  public IngressRuleBuilder() {
    this(false);
  }
  public IngressRuleBuilder(java.lang.Boolean validationEnabled) {
    this(new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressRule instance) {
    this(fluent, instance, false);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHost(instance.getHost()); 
    fluent.withHttp(instance.getHttp()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressRule instance) {
    this(instance,false);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHost(instance.getHost()); 
    this.withHttp(instance.getHttp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.IngressRule build() {
    IngressRule buildable = new IngressRule(fluent.getHost(),fluent.getHttp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressRuleBuilder that = (IngressRuleBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}