package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class NetworkPolicyListBuilder extends io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListBuilder>{
  public NetworkPolicyListBuilder() {
    this(false);
  }
  public NetworkPolicyListBuilder(java.lang.Boolean validationEnabled) {
    this(new NetworkPolicyList(), validationEnabled);
  }
  public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyList(), validationEnabled);
  }
  public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList instance) {
    this(instance,false);
  }
  public NetworkPolicyListBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList build() {
    NetworkPolicyList buildable = new NetworkPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyListBuilder that = (NetworkPolicyListBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}