package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressClassListBuilder extends io.fabric8.kubernetes.api.model.networking.v1.IngressClassListFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.IngressClassListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.IngressClassList,io.fabric8.kubernetes.api.model.networking.v1.IngressClassListBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1.IngressClassListFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressClassListBuilder() {
        this(true);
    }

    public IngressClassListBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressClassList(), validationEnabled);
    }

    public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassListFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassListFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressClassList(), validationEnabled);
    }

    public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressClassList instance) {
        this(fluent, instance, true);
    }

    public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressClassList instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassList instance) {
        this(instance,true);
    }

    public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassList instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressClassList build() {
        IngressClassList buildable = new IngressClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressClassListBuilder that = (IngressClassListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
