package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IPBlockBuilder extends IPBlockFluent<IPBlockBuilder> implements VisitableBuilder<IPBlock,IPBlockBuilder>{
  public IPBlockBuilder() {
    this(new IPBlock());
  }
  
  public IPBlockBuilder(IPBlockFluent<?> fluent) {
    this(fluent, new IPBlock());
  }
  
  public IPBlockBuilder(IPBlockFluent<?> fluent,IPBlock instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IPBlockBuilder(IPBlock instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IPBlockFluent<?> fluent;
  
  public IPBlock build() {
    IPBlock buildable = new IPBlock(fluent.getCidr(),fluent.getExcept());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}