package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressStatusBuilder extends IngressStatusFluent<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,IngressStatusBuilder>{
  public IngressStatusBuilder() {
    this(new IngressStatus());
  }
  
  public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
    this(fluent, new IngressStatus());
  }
  
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressStatusBuilder(IngressStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressStatusFluent<?> fluent;
  
  public IngressStatus build() {
    IngressStatus buildable = new IngressStatus(fluent.buildLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}