package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressBackendBuilder extends IngressBackendFluentImpl<IngressBackendBuilder> implements VisitableBuilder<IngressBackend,IngressBackendBuilder>{
  public IngressBackendBuilder() {
    this(false);
  }
  public IngressBackendBuilder(Boolean validationEnabled) {
    this(new IngressBackend(), validationEnabled);
  }
  public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressBackendBuilder(IngressBackendFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressBackend(), validationEnabled);
  }
  public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance) {
    this(fluent, instance, false);
  }
  public IngressBackendBuilder(IngressBackendFluent<?> fluent,IngressBackend instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResource(instance.getResource()); 
    fluent.withService(instance.getService()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressBackendBuilder(IngressBackend instance) {
    this(instance,false);
  }
  public IngressBackendBuilder(IngressBackend instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withResource(instance.getResource()); 
    this.withService(instance.getService()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressBackendFluent<?> fluent;
  Boolean validationEnabled;
  public IngressBackend build() {
    IngressBackend buildable = new IngressBackend(fluent.getResource(),fluent.getService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}