package io.fabric8.kubernetes.api.model.networking.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>> extends BaseFluent<A> implements IngressBackendFluent<A>{
  public IngressBackendFluentImpl() {
  }
  public IngressBackendFluentImpl(IngressBackend instance) {
    this.withResource(instance.getResource()); 
    this.withService(instance.getService()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private TypedLocalObjectReference resource;
  private IngressServiceBackendBuilder service;
  private Map<String,Object> additionalProperties;
  public TypedLocalObjectReference getResource() {
    return this.resource;
  }
  public A withResource(TypedLocalObjectReference resource) {
    this.resource=resource; return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public A withNewResource(String apiGroup,String kind,String name) {
    return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressServiceBackend getService() {
    return this.service!=null ?this.service.build():null;
  }
  public IngressServiceBackend buildService() {
    return this.service!=null ?this.service.build():null;
  }
  public A withService(IngressServiceBackend service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new IngressServiceBackendBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  public Boolean hasService() {
    return this.service != null;
  }
  public IngressBackendFluent.ServiceNested<A> withNewService() {
    return new IngressBackendFluentImpl.ServiceNestedImpl();
  }
  public IngressBackendFluent.ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
    return new IngressBackendFluentImpl.ServiceNestedImpl(item);
  }
  public IngressBackendFluent.ServiceNested<A> editService() {
    return withNewServiceLike(getService());
  }
  public IngressBackendFluent.ServiceNested<A> editOrNewService() {
    return withNewServiceLike(getService() != null ? getService(): new IngressServiceBackendBuilder().build());
  }
  public IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
    return withNewServiceLike(getService() != null ? getService(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (service != null ? !service.equals(that.service) :that.service != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(resource,  service,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceNestedImpl<N> extends IngressServiceBackendFluentImpl<IngressBackendFluent.ServiceNested<N>> implements IngressBackendFluent.ServiceNested<N>,Nested<N>{
    ServiceNestedImpl(IngressServiceBackend item) {
      this.builder = new IngressServiceBackendBuilder(this, item);
    }
    ServiceNestedImpl() {
      this.builder = new IngressServiceBackendBuilder(this);
    }
    IngressServiceBackendBuilder builder;
    public N and() {
      return (N) IngressBackendFluentImpl.this.withService(builder.build());
    }
    public N endService() {
      return and();
    }
    
  }
  
}