package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressListBuilder extends IngressListFluentImpl<IngressListBuilder> implements VisitableBuilder<IngressList,IngressListBuilder>{
  public IngressListBuilder() {
    this(false);
  }
  public IngressListBuilder(Boolean validationEnabled) {
    this(new IngressList(), validationEnabled);
  }
  public IngressListBuilder(IngressListFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressListBuilder(IngressListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressList(), validationEnabled);
  }
  public IngressListBuilder(IngressListFluent<?> fluent,IngressList instance) {
    this(fluent, instance, false);
  }
  public IngressListBuilder(IngressListFluent<?> fluent,IngressList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressListBuilder(IngressList instance) {
    this(instance,false);
  }
  public IngressListBuilder(IngressList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressListFluent<?> fluent;
  Boolean validationEnabled;
  public IngressList build() {
    IngressList buildable = new IngressList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}