package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressSpecFluentImpl<A extends IngressSpecFluent<A>> extends BaseFluent<A> implements IngressSpecFluent<A>{
  public IngressSpecFluentImpl() {
  }
  public IngressSpecFluentImpl(IngressSpec instance) {
    if (instance != null) {
      this.withDefaultBackend(instance.getDefaultBackend());
      this.withIngressClassName(instance.getIngressClassName());
      this.withRules(instance.getRules());
      this.withTls(instance.getTls());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private IngressBackendBuilder defaultBackend;
  private String ingressClassName;
  private ArrayList<IngressRuleBuilder> rules = new ArrayList<IngressRuleBuilder>();
  private ArrayList<IngressTLSBuilder> tls = new ArrayList<IngressTLSBuilder>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDefaultBackend instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressBackend getDefaultBackend() {
    return this.defaultBackend!=null ?this.defaultBackend.build():null;
  }
  public IngressBackend buildDefaultBackend() {
    return this.defaultBackend!=null ?this.defaultBackend.build():null;
  }
  public A withDefaultBackend(IngressBackend defaultBackend) {
    _visitables.get("defaultBackend").remove(this.defaultBackend);
    if (defaultBackend!=null){ this.defaultBackend= new IngressBackendBuilder(defaultBackend); _visitables.get("defaultBackend").add(this.defaultBackend);} else { this.defaultBackend = null; _visitables.get("defaultBackend").remove(this.defaultBackend); } return (A) this;
  }
  public Boolean hasDefaultBackend() {
    return this.defaultBackend != null;
  }
  public IngressSpecFluentImpl.DefaultBackendNested<A> withNewDefaultBackend() {
    return new IngressSpecFluentImpl.DefaultBackendNestedImpl();
  }
  public IngressSpecFluentImpl.DefaultBackendNested<A> withNewDefaultBackendLike(IngressBackend item) {
    return new IngressSpecFluentImpl.DefaultBackendNestedImpl(item);
  }
  public IngressSpecFluentImpl.DefaultBackendNested<A> editDefaultBackend() {
    return withNewDefaultBackendLike(getDefaultBackend());
  }
  public IngressSpecFluentImpl.DefaultBackendNested<A> editOrNewDefaultBackend() {
    return withNewDefaultBackendLike(getDefaultBackend() != null ? getDefaultBackend(): new IngressBackendBuilder().build());
  }
  public IngressSpecFluentImpl.DefaultBackendNested<A> editOrNewDefaultBackendLike(IngressBackend item) {
    return withNewDefaultBackendLike(getDefaultBackend() != null ? getDefaultBackend(): item);
  }
  public String getIngressClassName() {
    return this.ingressClassName;
  }
  public A withIngressClassName(String ingressClassName) {
    this.ingressClassName=ingressClassName; return (A) this;
  }
  public Boolean hasIngressClassName() {
    return this.ingressClassName != null;
  }
  public A addToRules(int index,IngressRule item) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    IngressRuleBuilder builder = new IngressRuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  public A setToRules(int index,IngressRule item) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    IngressRuleBuilder builder = new IngressRuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.networking.v1.IngressRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<IngressRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.networking.v1.IngressRule... items) {
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<IngressRule> items) {
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<IngressRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      IngressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IngressRule> getRules() {
    return rules != null ? build(rules) : null;
  }
  public List<IngressRule> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public IngressRule buildRule(int index) {
    return this.rules.get(index).build();
  }
  public IngressRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public IngressRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    for (IngressRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    for (IngressRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<IngressRule> rules) {
    if (this.rules != null) { _visitables.get("rules").clear();}
    if (rules != null) {this.rules = new ArrayList(); for (IngressRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.networking.v1.IngressRule... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (IngressRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public IngressSpecFluentImpl.RulesNested<A> addNewRule() {
    return new IngressSpecFluentImpl.RulesNestedImpl();
  }
  public IngressSpecFluentImpl.RulesNested<A> addNewRuleLike(IngressRule item) {
    return new IngressSpecFluentImpl.RulesNestedImpl(-1, item);
  }
  public IngressSpecFluentImpl.RulesNested<A> setNewRuleLike(int index,IngressRule item) {
    return new IngressSpecFluentImpl.RulesNestedImpl(index, item);
  }
  public IngressSpecFluentImpl.RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public IngressSpecFluentImpl.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public IngressSpecFluentImpl.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public IngressSpecFluentImpl.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public A addToTls(int index,IngressTLS item) {
    if (this.tls == null) {this.tls = new ArrayList<IngressTLSBuilder>();}
    IngressTLSBuilder builder = new IngressTLSBuilder(item);
    if (index < 0 || index >= tls.size()) { _visitables.get("tls").add(builder); tls.add(builder); } else { _visitables.get("tls").add(index, builder); tls.add(index, builder);}
    return (A)this;
  }
  public A setToTls(int index,IngressTLS item) {
    if (this.tls == null) {this.tls = new ArrayList<IngressTLSBuilder>();}
    IngressTLSBuilder builder = new IngressTLSBuilder(item);
    if (index < 0 || index >= tls.size()) { _visitables.get("tls").add(builder); tls.add(builder); } else { _visitables.get("tls").set(index, builder); tls.set(index, builder);}
    return (A)this;
  }
  public A addToTls(io.fabric8.kubernetes.api.model.networking.v1.IngressTLS... items) {
    if (this.tls == null) {this.tls = new ArrayList<IngressTLSBuilder>();}
    for (IngressTLS item : items) {IngressTLSBuilder builder = new IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
  }
  public A addAllToTls(Collection<IngressTLS> items) {
    if (this.tls == null) {this.tls = new ArrayList<IngressTLSBuilder>();}
    for (IngressTLS item : items) {IngressTLSBuilder builder = new IngressTLSBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
  }
  public A removeFromTls(io.fabric8.kubernetes.api.model.networking.v1.IngressTLS... items) {
    for (IngressTLS item : items) {IngressTLSBuilder builder = new IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
  }
  public A removeAllFromTls(Collection<IngressTLS> items) {
    for (IngressTLS item : items) {IngressTLSBuilder builder = new IngressTLSBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTls(Predicate<IngressTLSBuilder> predicate) {
    if (tls == null) return (A) this;
    final Iterator<IngressTLSBuilder> each = tls.iterator();
    final List visitables = _visitables.get("tls");
    while (each.hasNext()) {
      IngressTLSBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IngressTLS> getTls() {
    return tls != null ? build(tls) : null;
  }
  public List<IngressTLS> buildTls() {
    return tls != null ? build(tls) : null;
  }
  public IngressTLS buildTl(int index) {
    return this.tls.get(index).build();
  }
  public IngressTLS buildFirstTl() {
    return this.tls.get(0).build();
  }
  public IngressTLS buildLastTl() {
    return this.tls.get(tls.size() - 1).build();
  }
  public IngressTLS buildMatchingTl(Predicate<IngressTLSBuilder> predicate) {
    for (IngressTLSBuilder item: tls) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTl(Predicate<IngressTLSBuilder> predicate) {
    for (IngressTLSBuilder item: tls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTls(List<IngressTLS> tls) {
    if (this.tls != null) { _visitables.get("tls").clear();}
    if (tls != null) {this.tls = new ArrayList(); for (IngressTLS item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
  }
  public A withTls(io.fabric8.kubernetes.api.model.networking.v1.IngressTLS... tls) {
    if (this.tls != null) {this.tls.clear(); _visitables.remove("tls"); }
    if (tls != null) {for (IngressTLS item :tls){ this.addToTls(item);}} return (A) this;
  }
  public Boolean hasTls() {
    return tls != null && !tls.isEmpty();
  }
  public IngressSpecFluentImpl.TlsNested<A> addNewTl() {
    return new IngressSpecFluentImpl.TlsNestedImpl();
  }
  public IngressSpecFluentImpl.TlsNested<A> addNewTlLike(IngressTLS item) {
    return new IngressSpecFluentImpl.TlsNestedImpl(-1, item);
  }
  public IngressSpecFluentImpl.TlsNested<A> setNewTlLike(int index,IngressTLS item) {
    return new IngressSpecFluentImpl.TlsNestedImpl(index, item);
  }
  public IngressSpecFluentImpl.TlsNested<A> editTl(int index) {
    if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
    return setNewTlLike(index, buildTl(index));
  }
  public IngressSpecFluentImpl.TlsNested<A> editFirstTl() {
    if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
    return setNewTlLike(0, buildTl(0));
  }
  public IngressSpecFluentImpl.TlsNested<A> editLastTl() {
    int index = tls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
    return setNewTlLike(index, buildTl(index));
  }
  public IngressSpecFluentImpl.TlsNested<A> editMatchingTl(Predicate<IngressTLSBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tls.size();i++) { 
    if (predicate.test(tls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
    return setNewTlLike(index, buildTl(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressSpecFluentImpl that = (IngressSpecFluentImpl) o;
    if (!java.util.Objects.equals(defaultBackend, that.defaultBackend)) return false;

    if (!java.util.Objects.equals(ingressClassName, that.ingressClassName)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(defaultBackend,  ingressClassName,  rules,  tls,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultBackend != null) { sb.append("defaultBackend:"); sb.append(defaultBackend + ","); }
    if (ingressClassName != null) { sb.append("ingressClassName:"); sb.append(ingressClassName + ","); }
    if (rules != null) { sb.append("rules:"); sb.append(rules + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DefaultBackendNestedImpl<N> extends IngressBackendFluentImpl<IngressSpecFluentImpl.DefaultBackendNested<N>> implements IngressSpecFluentImpl.DefaultBackendNested<N>,Nested<N>{
    DefaultBackendNestedImpl(IngressBackend item) {
      this.builder = new IngressBackendBuilder(this, item);
    }
    DefaultBackendNestedImpl() {
      this.builder = new IngressBackendBuilder(this);
    }
    IngressBackendBuilder builder;
    public N and() {
      return (N) IngressSpecFluentImpl.this.withDefaultBackend(builder.build());
    }
    public N endDefaultBackend() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends IngressRuleFluentImpl<IngressSpecFluentImpl.RulesNested<N>> implements IngressSpecFluentImpl.RulesNested<N>,Nested<N>{
    RulesNestedImpl(int index,IngressRule item) {
      this.index = index;
      this.builder = new IngressRuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new IngressRuleBuilder(this);
    }
    IngressRuleBuilder builder;
    int index;
    public N and() {
      return (N) IngressSpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  class TlsNestedImpl<N> extends IngressTLSFluentImpl<IngressSpecFluentImpl.TlsNested<N>> implements IngressSpecFluentImpl.TlsNested<N>,Nested<N>{
    TlsNestedImpl(int index,IngressTLS item) {
      this.index = index;
      this.builder = new IngressTLSBuilder(this, item);
    }
    TlsNestedImpl() {
      this.index = -1;
      this.builder = new IngressTLSBuilder(this);
    }
    IngressTLSBuilder builder;
    int index;
    public N and() {
      return (N) IngressSpecFluentImpl.this.setToTls(index,builder.build());
    }
    public N endTl() {
      return and();
    }
    
  }
  
}