package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ClusterCIDRFluent<A extends ClusterCIDRFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ClusterCIDRFluent.MetadataNested<A> withNewMetadata();
  public ClusterCIDRFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ClusterCIDRFluent.MetadataNested<A> editMetadata();
  public ClusterCIDRFluent.MetadataNested<A> editOrNewMetadata();
  public ClusterCIDRFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterCIDRSpec getSpec();
  public ClusterCIDRSpec buildSpec();
  public A withSpec(ClusterCIDRSpec spec);
  public Boolean hasSpec();
  public ClusterCIDRFluent.SpecNested<A> withNewSpec();
  public ClusterCIDRFluent.SpecNested<A> withNewSpecLike(ClusterCIDRSpec item);
  public ClusterCIDRFluent.SpecNested<A> editSpec();
  public ClusterCIDRFluent.SpecNested<A> editOrNewSpec();
  public ClusterCIDRFluent.SpecNested<A> editOrNewSpecLike(ClusterCIDRSpec item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ClusterCIDRFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,ClusterCIDRSpecFluent<ClusterCIDRFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  
}