package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPAddressListBuilder extends IPAddressListFluent<IPAddressListBuilder> implements VisitableBuilder<IPAddressList,IPAddressListBuilder>{
  public IPAddressListBuilder() {
    this(false);
  }
  public IPAddressListBuilder(Boolean validationEnabled) {
    this(new IPAddressList(), validationEnabled);
  }
  public IPAddressListBuilder(IPAddressListFluent<?> fluent) {
    this(fluent, false);
  }
  public IPAddressListBuilder(IPAddressListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPAddressList(), validationEnabled);
  }
  public IPAddressListBuilder(IPAddressListFluent<?> fluent,IPAddressList instance) {
    this(fluent, instance, false);
  }
  public IPAddressListBuilder(IPAddressListFluent<?> fluent,IPAddressList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IPAddressList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPAddressListBuilder(IPAddressList instance) {
    this(instance,false);
  }
  public IPAddressListBuilder(IPAddressList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IPAddressList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPAddressListFluent<?> fluent;
  Boolean validationEnabled;
  public IPAddressList build() {
    IPAddressList buildable = new IPAddressList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}