package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IngressClassParametersReferenceBuilder extends IngressClassParametersReferenceFluent<IngressClassParametersReferenceBuilder> implements VisitableBuilder<IngressClassParametersReference,IngressClassParametersReferenceBuilder>{
  public IngressClassParametersReferenceBuilder() {
    this(new IngressClassParametersReference());
  }
  
  public IngressClassParametersReferenceBuilder(IngressClassParametersReferenceFluent<?> fluent) {
    this(fluent, new IngressClassParametersReference());
  }
  
  public IngressClassParametersReferenceBuilder(IngressClassParametersReferenceFluent<?> fluent,IngressClassParametersReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IngressClassParametersReferenceBuilder(IngressClassParametersReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IngressClassParametersReferenceFluent<?> fluent;
  
  public IngressClassParametersReference build() {
    IngressClassParametersReference buildable = new IngressClassParametersReference(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getScope());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}