package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPIngressRuleValueFluent<A extends HTTPIngressRuleValueFluent<A>> extends BaseFluent<A>{
  public HTTPIngressRuleValueFluent() {
  }
  
  public HTTPIngressRuleValueFluent(HTTPIngressRuleValue instance) {
    this.copyInstance(instance);
  }
  private ArrayList<HTTPIngressPathBuilder> paths = new ArrayList<HTTPIngressPathBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPIngressRuleValue instance) {
    instance = (instance != null ? instance : new HTTPIngressRuleValue());
    if (instance != null) {
          this.withPaths(instance.getPaths());
          this.withPaths(instance.getPaths());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToPaths(int index,HTTPIngressPath item) {
    if (this.paths == null) {this.paths = new ArrayList<HTTPIngressPathBuilder>();}
    HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
    if (index < 0 || index >= paths.size()) { _visitables.get("paths").add(builder); paths.add(builder); } else { _visitables.get("paths").add(index, builder); paths.add(index, builder);}
    return (A)this;
  }
  
  public A setToPaths(int index,HTTPIngressPath item) {
    if (this.paths == null) {this.paths = new ArrayList<HTTPIngressPathBuilder>();}
    HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
    if (index < 0 || index >= paths.size()) { _visitables.get("paths").add(builder); paths.add(builder); } else { _visitables.get("paths").set(index, builder); paths.set(index, builder);}
    return (A)this;
  }
  
  public A addToPaths(io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPath... items) {
    if (this.paths == null) {this.paths = new ArrayList<HTTPIngressPathBuilder>();}
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.get("paths").add(builder);this.paths.add(builder);} return (A)this;
  }
  
  public A addAllToPaths(Collection<HTTPIngressPath> items) {
    if (this.paths == null) {this.paths = new ArrayList<HTTPIngressPathBuilder>();}
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.get("paths").add(builder);this.paths.add(builder);} return (A)this;
  }
  
  public A removeFromPaths(io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPath... items) {
    if (this.paths == null) return (A)this;
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.get("paths").remove(builder); this.paths.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPaths(Collection<HTTPIngressPath> items) {
    if (this.paths == null) return (A)this;
    for (HTTPIngressPath item : items) {HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);_visitables.get("paths").remove(builder); this.paths.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPaths(Predicate<HTTPIngressPathBuilder> predicate) {
    if (paths == null) return (A) this;
    final Iterator<HTTPIngressPathBuilder> each = paths.iterator();
    final List visitables = _visitables.get("paths");
    while (each.hasNext()) {
      HTTPIngressPathBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPIngressPath> buildPaths() {
    return this.paths != null ? build(paths) : null;
  }
  
  public HTTPIngressPath buildPath(int index) {
    return this.paths.get(index).build();
  }
  
  public HTTPIngressPath buildFirstPath() {
    return this.paths.get(0).build();
  }
  
  public HTTPIngressPath buildLastPath() {
    return this.paths.get(paths.size() - 1).build();
  }
  
  public HTTPIngressPath buildMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
      for (HTTPIngressPathBuilder item : paths) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
      for (HTTPIngressPathBuilder item : paths) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPaths(List<HTTPIngressPath> paths) {
    if (this.paths != null) {
      this._visitables.get("paths").clear();
    }
    if (paths != null) {
        this.paths = new ArrayList();
        for (HTTPIngressPath item : paths) {
          this.addToPaths(item);
        }
    } else {
      this.paths = null;
    }
    return (A) this;
  }
  
  public A withPaths(io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPath... paths) {
    if (this.paths != null) {this.paths.clear(); _visitables.remove("paths"); }
    if (paths != null) {for (HTTPIngressPath item :paths){ this.addToPaths(item);}} return (A) this;
  }
  
  public boolean hasPaths() {
    return this.paths != null && !this.paths.isEmpty();
  }
  
  public PathsNested<A> addNewPath() {
    return new PathsNested(-1, null);
  }
  
  public PathsNested<A> addNewPathLike(HTTPIngressPath item) {
    return new PathsNested(-1, item);
  }
  
  public PathsNested<A> setNewPathLike(int index,HTTPIngressPath item) {
    return new PathsNested(index, item);
  }
  
  public PathsNested<A> editPath(int index) {
    if (paths.size() <= index) throw new RuntimeException("Can't edit paths. Index exceeds size.");
    return setNewPathLike(index, buildPath(index));
  }
  
  public PathsNested<A> editFirstPath() {
    if (paths.size() == 0) throw new RuntimeException("Can't edit first paths. The list is empty.");
    return setNewPathLike(0, buildPath(0));
  }
  
  public PathsNested<A> editLastPath() {
    int index = paths.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last paths. The list is empty.");
    return setNewPathLike(index, buildPath(index));
  }
  
  public PathsNested<A> editMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
    int index = -1;
    for (int i=0;i<paths.size();i++) { 
    if (predicate.test(paths.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching paths. No match found.");
    return setNewPathLike(index, buildPath(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPIngressRuleValueFluent that = (HTTPIngressRuleValueFluent) o;
    if (!java.util.Objects.equals(paths, that.paths)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(paths,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (paths != null && !paths.isEmpty()) { sb.append("paths:"); sb.append(paths + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PathsNested<N> extends HTTPIngressPathFluent<PathsNested<N>> implements Nested<N>{
    PathsNested(int index,HTTPIngressPath item) {
      this.index = index;
      this.builder = new HTTPIngressPathBuilder(this, item);
    }
    HTTPIngressPathBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPIngressRuleValueFluent.this.setToPaths(index,builder.build());
    }
    
    public N endPath() {
      return and();
    }
    
  
  }

}