package io.fabric8.kubernetes.api.model.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuntimeClassBuilder extends RuntimeClassFluentImpl<RuntimeClassBuilder> implements VisitableBuilder<RuntimeClass,RuntimeClassBuilder>{
  public RuntimeClassBuilder() {
    this(false);
  }
  public RuntimeClassBuilder(Boolean validationEnabled) {
    this(new RuntimeClass(), validationEnabled);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent) {
    this(fluent, false);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuntimeClass(), validationEnabled);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance) {
    this(fluent, instance, false);
  }
  public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RuntimeClassBuilder(RuntimeClass instance) {
    this(instance,false);
  }
  public RuntimeClassBuilder(RuntimeClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RuntimeClassFluent<?> fluent;
  Boolean validationEnabled;
  public RuntimeClass build() {
    RuntimeClass buildable = new RuntimeClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}