package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodSecurityPolicySpecBuilder extends io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluentImpl<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec,io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecBuilder> {

    io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodSecurityPolicySpecBuilder() {
        this(true);
    }

    public PodSecurityPolicySpecBuilder(java.lang.Boolean validationEnabled) {
        this(new PodSecurityPolicySpec(), validationEnabled);
    }

    public PodSecurityPolicySpecBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public PodSecurityPolicySpecBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicySpec(), validationEnabled);
    }

    public PodSecurityPolicySpecBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicySpecBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpecFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
        fluent.withAllowedCSIDrivers(instance.getAllowedCSIDrivers()); 
        fluent.withAllowedCapabilities(instance.getAllowedCapabilities()); 
        fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
        fluent.withAllowedHostPaths(instance.getAllowedHostPaths()); 
        fluent.withAllowedProcMountTypes(instance.getAllowedProcMountTypes()); 
        fluent.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
        fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
        fluent.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
        fluent.withForbiddenSysctls(instance.getForbiddenSysctls()); 
        fluent.withFsGroup(instance.getFsGroup()); 
        fluent.withHostIPC(instance.getHostIPC()); 
        fluent.withHostNetwork(instance.getHostNetwork()); 
        fluent.withHostPID(instance.getHostPID()); 
        fluent.withHostPorts(instance.getHostPorts()); 
        fluent.withPrivileged(instance.getPrivileged()); 
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
        fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
        fluent.withRunAsGroup(instance.getRunAsGroup()); 
        fluent.withRunAsUser(instance.getRunAsUser()); 
        fluent.withRuntimeClass(instance.getRuntimeClass()); 
        fluent.withSeLinux(instance.getSeLinux()); 
        fluent.withSupplementalGroups(instance.getSupplementalGroups()); 
        fluent.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodSecurityPolicySpecBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec instance) {
        this(instance,true);
    }

    public PodSecurityPolicySpecBuilder(io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
        this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers()); 
        this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes()); 
        this.withAllowedHostPaths(instance.getAllowedHostPaths()); 
        this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes()); 
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls()); 
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
        this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation()); 
        this.withForbiddenSysctls(instance.getForbiddenSysctls()); 
        this.withFsGroup(instance.getFsGroup()); 
        this.withHostIPC(instance.getHostIPC()); 
        this.withHostNetwork(instance.getHostNetwork()); 
        this.withHostPID(instance.getHostPID()); 
        this.withHostPorts(instance.getHostPorts()); 
        this.withPrivileged(instance.getPrivileged()); 
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
        this.withRunAsGroup(instance.getRunAsGroup()); 
        this.withRunAsUser(instance.getRunAsUser()); 
        this.withRuntimeClass(instance.getRuntimeClass()); 
        this.withSeLinux(instance.getSeLinux()); 
        this.withSupplementalGroups(instance.getSupplementalGroups()); 
        this.withVolumes(instance.getVolumes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec build() {
        PodSecurityPolicySpec buildable = new PodSecurityPolicySpec(fluent.getAllowPrivilegeEscalation(),fluent.getAllowedCSIDrivers(),fluent.getAllowedCapabilities(),fluent.getAllowedFlexVolumes(),fluent.getAllowedHostPaths(),fluent.getAllowedProcMountTypes(),fluent.getAllowedUnsafeSysctls(),fluent.getDefaultAddCapabilities(),fluent.getDefaultAllowPrivilegeEscalation(),fluent.getForbiddenSysctls(),fluent.getFsGroup(),fluent.getHostIPC(),fluent.getHostNetwork(),fluent.getHostPID(),fluent.getHostPorts(),fluent.getPrivileged(),fluent.getReadOnlyRootFilesystem(),fluent.getRequiredDropCapabilities(),fluent.getRunAsGroup(),fluent.getRunAsUser(),fluent.getRuntimeClass(),fluent.getSeLinux(),fluent.getSupplementalGroups(),fluent.getVolumes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodSecurityPolicySpecBuilder that = (PodSecurityPolicySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
