package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public interface PodSecurityPolicySpecFluent<A extends PodSecurityPolicySpecFluent<A>> extends Fluent<A>{
  public Boolean getAllowPrivilegeEscalation();
  public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
  public Boolean hasAllowPrivilegeEscalation();
  public A addToAllowedCSIDrivers(int index,AllowedCSIDriver item);
  public A setToAllowedCSIDrivers(int index,AllowedCSIDriver item);
  public A addToAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... items);
  public A addAllToAllowedCSIDrivers(Collection<AllowedCSIDriver> items);
  public A removeFromAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... items);
  public A removeAllFromAllowedCSIDrivers(Collection<AllowedCSIDriver> items);
  public A removeMatchingFromAllowedCSIDrivers(Predicate<AllowedCSIDriverBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAllowedCSIDrivers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedCSIDriver> getAllowedCSIDrivers();
  public List<AllowedCSIDriver> buildAllowedCSIDrivers();
  public AllowedCSIDriver buildAllowedCSIDriver(int index);
  public AllowedCSIDriver buildFirstAllowedCSIDriver();
  public AllowedCSIDriver buildLastAllowedCSIDriver();
  public AllowedCSIDriver buildMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate);
  public Boolean hasMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate);
  public A withAllowedCSIDrivers(List<AllowedCSIDriver> allowedCSIDrivers);
  public A withAllowedCSIDrivers(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver... allowedCSIDrivers);
  public Boolean hasAllowedCSIDrivers();
  public A addNewAllowedCSIDriver(String name);
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriver();
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> addNewAllowedCSIDriverLike(AllowedCSIDriver item);
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> setNewAllowedCSIDriverLike(int index,AllowedCSIDriver item);
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editAllowedCSIDriver(int index);
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editFirstAllowedCSIDriver();
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editLastAllowedCSIDriver();
  public PodSecurityPolicySpecFluent.AllowedCSIDriversNested<A> editMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate);
  public A addToAllowedCapabilities(int index,String item);
  public A setToAllowedCapabilities(int index,String item);
  public A addToAllowedCapabilities(java.lang.String... items);
  public A addAllToAllowedCapabilities(Collection<String> items);
  public A removeFromAllowedCapabilities(java.lang.String... items);
  public A removeAllFromAllowedCapabilities(Collection<String> items);
  public List<String> getAllowedCapabilities();
  public String getAllowedCapability(int index);
  public String getFirstAllowedCapability();
  public String getLastAllowedCapability();
  public String getMatchingAllowedCapability(Predicate<String> predicate);
  public Boolean hasMatchingAllowedCapability(Predicate<String> predicate);
  public A withAllowedCapabilities(List<String> allowedCapabilities);
  public A withAllowedCapabilities(java.lang.String... allowedCapabilities);
  public Boolean hasAllowedCapabilities();
  public A addToAllowedFlexVolumes(int index,AllowedFlexVolume item);
  public A setToAllowedFlexVolumes(int index,AllowedFlexVolume item);
  public A addToAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... items);
  public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items);
  public A removeFromAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... items);
  public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items);
  public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedFlexVolume> getAllowedFlexVolumes();
  public List<AllowedFlexVolume> buildAllowedFlexVolumes();
  public AllowedFlexVolume buildAllowedFlexVolume(int index);
  public AllowedFlexVolume buildFirstAllowedFlexVolume();
  public AllowedFlexVolume buildLastAllowedFlexVolume();
  public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
  public Boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
  public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes);
  public A withAllowedFlexVolumes(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume... allowedFlexVolumes);
  public Boolean hasAllowedFlexVolumes();
  public A addNewAllowedFlexVolume(String driver);
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume();
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item);
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index,AllowedFlexVolume item);
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index);
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume();
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume();
  public PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate);
  public A addToAllowedHostPaths(int index,AllowedHostPath item);
  public A setToAllowedHostPaths(int index,AllowedHostPath item);
  public A addToAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... items);
  public A addAllToAllowedHostPaths(Collection<AllowedHostPath> items);
  public A removeFromAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... items);
  public A removeAllFromAllowedHostPaths(Collection<AllowedHostPath> items);
  public A removeMatchingFromAllowedHostPaths(Predicate<AllowedHostPathBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAllowedHostPaths instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AllowedHostPath> getAllowedHostPaths();
  public List<AllowedHostPath> buildAllowedHostPaths();
  public AllowedHostPath buildAllowedHostPath(int index);
  public AllowedHostPath buildFirstAllowedHostPath();
  public AllowedHostPath buildLastAllowedHostPath();
  public AllowedHostPath buildMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate);
  public Boolean hasMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate);
  public A withAllowedHostPaths(List<AllowedHostPath> allowedHostPaths);
  public A withAllowedHostPaths(io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath... allowedHostPaths);
  public Boolean hasAllowedHostPaths();
  public A addNewAllowedHostPath(String pathPrefix,Boolean readOnly);
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath();
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(AllowedHostPath item);
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index,AllowedHostPath item);
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(int index);
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath();
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath();
  public PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate);
  public A addToAllowedProcMountTypes(int index,String item);
  public A setToAllowedProcMountTypes(int index,String item);
  public A addToAllowedProcMountTypes(java.lang.String... items);
  public A addAllToAllowedProcMountTypes(Collection<String> items);
  public A removeFromAllowedProcMountTypes(java.lang.String... items);
  public A removeAllFromAllowedProcMountTypes(Collection<String> items);
  public List<String> getAllowedProcMountTypes();
  public String getAllowedProcMountType(int index);
  public String getFirstAllowedProcMountType();
  public String getLastAllowedProcMountType();
  public String getMatchingAllowedProcMountType(Predicate<String> predicate);
  public Boolean hasMatchingAllowedProcMountType(Predicate<String> predicate);
  public A withAllowedProcMountTypes(List<String> allowedProcMountTypes);
  public A withAllowedProcMountTypes(java.lang.String... allowedProcMountTypes);
  public Boolean hasAllowedProcMountTypes();
  public A addToAllowedUnsafeSysctls(int index,String item);
  public A setToAllowedUnsafeSysctls(int index,String item);
  public A addToAllowedUnsafeSysctls(java.lang.String... items);
  public A addAllToAllowedUnsafeSysctls(Collection<String> items);
  public A removeFromAllowedUnsafeSysctls(java.lang.String... items);
  public A removeAllFromAllowedUnsafeSysctls(Collection<String> items);
  public List<String> getAllowedUnsafeSysctls();
  public String getAllowedUnsafeSysctl(int index);
  public String getFirstAllowedUnsafeSysctl();
  public String getLastAllowedUnsafeSysctl();
  public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate);
  public Boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate);
  public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls);
  public A withAllowedUnsafeSysctls(java.lang.String... allowedUnsafeSysctls);
  public Boolean hasAllowedUnsafeSysctls();
  public A addToDefaultAddCapabilities(int index,String item);
  public A setToDefaultAddCapabilities(int index,String item);
  public A addToDefaultAddCapabilities(java.lang.String... items);
  public A addAllToDefaultAddCapabilities(Collection<String> items);
  public A removeFromDefaultAddCapabilities(java.lang.String... items);
  public A removeAllFromDefaultAddCapabilities(Collection<String> items);
  public List<String> getDefaultAddCapabilities();
  public String getDefaultAddCapability(int index);
  public String getFirstDefaultAddCapability();
  public String getLastDefaultAddCapability();
  public String getMatchingDefaultAddCapability(Predicate<String> predicate);
  public Boolean hasMatchingDefaultAddCapability(Predicate<String> predicate);
  public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
  public A withDefaultAddCapabilities(java.lang.String... defaultAddCapabilities);
  public Boolean hasDefaultAddCapabilities();
  public Boolean getDefaultAllowPrivilegeEscalation();
  public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation);
  public Boolean hasDefaultAllowPrivilegeEscalation();
  public A addToForbiddenSysctls(int index,String item);
  public A setToForbiddenSysctls(int index,String item);
  public A addToForbiddenSysctls(java.lang.String... items);
  public A addAllToForbiddenSysctls(Collection<String> items);
  public A removeFromForbiddenSysctls(java.lang.String... items);
  public A removeAllFromForbiddenSysctls(Collection<String> items);
  public List<String> getForbiddenSysctls();
  public String getForbiddenSysctl(int index);
  public String getFirstForbiddenSysctl();
  public String getLastForbiddenSysctl();
  public String getMatchingForbiddenSysctl(Predicate<String> predicate);
  public Boolean hasMatchingForbiddenSysctl(Predicate<String> predicate);
  public A withForbiddenSysctls(List<String> forbiddenSysctls);
  public A withForbiddenSysctls(java.lang.String... forbiddenSysctls);
  public Boolean hasForbiddenSysctls();
  
  /**
   * This method has been deprecated, please use method buildFsGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public FSGroupStrategyOptions getFsGroup();
  public FSGroupStrategyOptions buildFsGroup();
  public A withFsGroup(FSGroupStrategyOptions fsGroup);
  public Boolean hasFsGroup();
  public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup();
  public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item);
  public PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup();
  public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup();
  public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item);
  public Boolean getHostIPC();
  public A withHostIPC(Boolean hostIPC);
  public Boolean hasHostIPC();
  public Boolean getHostNetwork();
  public A withHostNetwork(Boolean hostNetwork);
  public Boolean hasHostNetwork();
  public Boolean getHostPID();
  public A withHostPID(Boolean hostPID);
  public Boolean hasHostPID();
  public A addToHostPorts(int index,HostPortRange item);
  public A setToHostPorts(int index,HostPortRange item);
  public A addToHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... items);
  public A addAllToHostPorts(Collection<HostPortRange> items);
  public A removeFromHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... items);
  public A removeAllFromHostPorts(Collection<HostPortRange> items);
  public A removeMatchingFromHostPorts(Predicate<HostPortRangeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHostPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HostPortRange> getHostPorts();
  public List<HostPortRange> buildHostPorts();
  public HostPortRange buildHostPort(int index);
  public HostPortRange buildFirstHostPort();
  public HostPortRange buildLastHostPort();
  public HostPortRange buildMatchingHostPort(Predicate<HostPortRangeBuilder> predicate);
  public Boolean hasMatchingHostPort(Predicate<HostPortRangeBuilder> predicate);
  public A withHostPorts(List<HostPortRange> hostPorts);
  public A withHostPorts(io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange... hostPorts);
  public Boolean hasHostPorts();
  public A addNewHostPort(Integer max,Integer min);
  public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort();
  public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(HostPortRange item);
  public PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index,HostPortRange item);
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index);
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort();
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort();
  public PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(Predicate<HostPortRangeBuilder> predicate);
  public Boolean getPrivileged();
  public A withPrivileged(Boolean privileged);
  public Boolean hasPrivileged();
  public Boolean getReadOnlyRootFilesystem();
  public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
  public Boolean hasReadOnlyRootFilesystem();
  public A addToRequiredDropCapabilities(int index,String item);
  public A setToRequiredDropCapabilities(int index,String item);
  public A addToRequiredDropCapabilities(java.lang.String... items);
  public A addAllToRequiredDropCapabilities(Collection<String> items);
  public A removeFromRequiredDropCapabilities(java.lang.String... items);
  public A removeAllFromRequiredDropCapabilities(Collection<String> items);
  public List<String> getRequiredDropCapabilities();
  public String getRequiredDropCapability(int index);
  public String getFirstRequiredDropCapability();
  public String getLastRequiredDropCapability();
  public String getMatchingRequiredDropCapability(Predicate<String> predicate);
  public Boolean hasMatchingRequiredDropCapability(Predicate<String> predicate);
  public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
  public A withRequiredDropCapabilities(java.lang.String... requiredDropCapabilities);
  public Boolean hasRequiredDropCapabilities();
  
  /**
   * This method has been deprecated, please use method buildRunAsGroup instead.
   * @return The buildable object.
   */
  @Deprecated
  public RunAsGroupStrategyOptions getRunAsGroup();
  public RunAsGroupStrategyOptions buildRunAsGroup();
  public A withRunAsGroup(RunAsGroupStrategyOptions runAsGroup);
  public Boolean hasRunAsGroup();
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroup();
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> withNewRunAsGroupLike(RunAsGroupStrategyOptions item);
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editRunAsGroup();
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroup();
  public PodSecurityPolicySpecFluent.RunAsGroupNested<A> editOrNewRunAsGroupLike(RunAsGroupStrategyOptions item);
  
  /**
   * This method has been deprecated, please use method buildRunAsUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public RunAsUserStrategyOptions getRunAsUser();
  public RunAsUserStrategyOptions buildRunAsUser();
  public A withRunAsUser(RunAsUserStrategyOptions runAsUser);
  public Boolean hasRunAsUser();
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser();
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item);
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser();
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser();
  public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item);
  
  /**
   * This method has been deprecated, please use method buildRuntimeClass instead.
   * @return The buildable object.
   */
  @Deprecated
  public RuntimeClassStrategyOptions getRuntimeClass();
  public RuntimeClassStrategyOptions buildRuntimeClass();
  public A withRuntimeClass(RuntimeClassStrategyOptions runtimeClass);
  public Boolean hasRuntimeClass();
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClass();
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> withNewRuntimeClassLike(RuntimeClassStrategyOptions item);
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editRuntimeClass();
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClass();
  public PodSecurityPolicySpecFluent.RuntimeClassNested<A> editOrNewRuntimeClassLike(RuntimeClassStrategyOptions item);
  
  /**
   * This method has been deprecated, please use method buildSeLinux instead.
   * @return The buildable object.
   */
  @Deprecated
  public SELinuxStrategyOptions getSeLinux();
  public SELinuxStrategyOptions buildSeLinux();
  public A withSeLinux(SELinuxStrategyOptions seLinux);
  public Boolean hasSeLinux();
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux();
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item);
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux();
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux();
  public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item);
  
  /**
   * This method has been deprecated, please use method buildSupplementalGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public SupplementalGroupsStrategyOptions getSupplementalGroups();
  public SupplementalGroupsStrategyOptions buildSupplementalGroups();
  public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups);
  public Boolean hasSupplementalGroups();
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups();
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
  public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
  public A addToVolumes(int index,String item);
  public A setToVolumes(int index,String item);
  public A addToVolumes(java.lang.String... items);
  public A addAllToVolumes(Collection<String> items);
  public A removeFromVolumes(java.lang.String... items);
  public A removeAllFromVolumes(Collection<String> items);
  public List<String> getVolumes();
  public String getVolume(int index);
  public String getFirstVolume();
  public String getLastVolume();
  public String getMatchingVolume(Predicate<String> predicate);
  public Boolean hasMatchingVolume(Predicate<String> predicate);
  public A withVolumes(List<String> volumes);
  public A withVolumes(java.lang.String... volumes);
  public Boolean hasVolumes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAllowPrivilegeEscalation();
  public A withDefaultAllowPrivilegeEscalation();
  public A withHostIPC();
  public A withHostNetwork();
  public A withHostPID();
  public A withPrivileged();
  public A withReadOnlyRootFilesystem();
  public interface AllowedCSIDriversNested<N> extends Nested<N>,AllowedCSIDriverFluent<PodSecurityPolicySpecFluent.AllowedCSIDriversNested<N>>{
    public N and();
    public N endAllowedCSIDriver();
    
  }
  public interface AllowedFlexVolumesNested<N> extends Nested<N>,AllowedFlexVolumeFluent<PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>>{
    public N and();
    public N endAllowedFlexVolume();
    
  }
  public interface AllowedHostPathsNested<N> extends Nested<N>,AllowedHostPathFluent<PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>>{
    public N and();
    public N endAllowedHostPath();
    
  }
  public interface FsGroupNested<N> extends Nested<N>,FSGroupStrategyOptionsFluent<PodSecurityPolicySpecFluent.FsGroupNested<N>>{
    public N and();
    public N endFsGroup();
    
  }
  public interface HostPortsNested<N> extends Nested<N>,HostPortRangeFluent<PodSecurityPolicySpecFluent.HostPortsNested<N>>{
    public N and();
    public N endHostPort();
    
  }
  public interface RunAsGroupNested<N> extends Nested<N>,RunAsGroupStrategyOptionsFluent<PodSecurityPolicySpecFluent.RunAsGroupNested<N>>{
    public N and();
    public N endRunAsGroup();
    
  }
  public interface RunAsUserNested<N> extends Nested<N>,RunAsUserStrategyOptionsFluent<PodSecurityPolicySpecFluent.RunAsUserNested<N>>{
    public N and();
    public N endRunAsUser();
    
  }
  public interface RuntimeClassNested<N> extends Nested<N>,RuntimeClassStrategyOptionsFluent<PodSecurityPolicySpecFluent.RuntimeClassNested<N>>{
    public N and();
    public N endRuntimeClass();
    
  }
  public interface SeLinuxNested<N> extends Nested<N>,SELinuxStrategyOptionsFluent<PodSecurityPolicySpecFluent.SeLinuxNested<N>>{
    public N and();
    public N endSeLinux();
    
  }
  public interface SupplementalGroupsNested<N> extends Nested<N>,SupplementalGroupsStrategyOptionsFluent<PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>{
    public N and();
    public N endSupplementalGroups();
    
  }
  
}