package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyListBuilder extends PodSecurityPolicyListFluent<PodSecurityPolicyListBuilder> implements VisitableBuilder<PodSecurityPolicyList,PodSecurityPolicyListBuilder>{
  public PodSecurityPolicyListBuilder() {
    this(false);
  }
  public PodSecurityPolicyListBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicyList(), validationEnabled);
  }
  public PodSecurityPolicyListBuilder(PodSecurityPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyListBuilder(PodSecurityPolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicyList(), validationEnabled);
  }
  public PodSecurityPolicyListBuilder(PodSecurityPolicyListFluent<?> fluent,PodSecurityPolicyList instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyListBuilder(PodSecurityPolicyListFluent<?> fluent,PodSecurityPolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSecurityPolicyList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyListBuilder(PodSecurityPolicyList instance) {
    this(instance,false);
  }
  public PodSecurityPolicyListBuilder(PodSecurityPolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSecurityPolicyList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicyList build() {
    PodSecurityPolicyList buildable = new PodSecurityPolicyList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}