package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FSGroupStrategyOptionsBuilder extends FSGroupStrategyOptionsFluent<FSGroupStrategyOptionsBuilder> implements VisitableBuilder<FSGroupStrategyOptions,FSGroupStrategyOptionsBuilder>{
  public FSGroupStrategyOptionsBuilder() {
    this(false);
  }
  public FSGroupStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new FSGroupStrategyOptions(), validationEnabled);
  }
  public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FSGroupStrategyOptions(), validationEnabled);
  }
  public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent,FSGroupStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent,FSGroupStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FSGroupStrategyOptions());

    if (instance != null) {
      fluent.withRanges(instance.getRanges());
      fluent.withRule(instance.getRule());
      fluent.withRanges(instance.getRanges());
      fluent.withRule(instance.getRule());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance) {
    this(instance,false);
  }
  public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FSGroupStrategyOptions());

    if (instance != null) {
      this.withRanges(instance.getRanges());
      this.withRule(instance.getRule());
      this.withRanges(instance.getRanges());
      this.withRule(instance.getRule());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FSGroupStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public FSGroupStrategyOptions build() {
    FSGroupStrategyOptions buildable = new FSGroupStrategyOptions(fluent.buildRanges(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}