package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class RoleRefBuilder extends io.fabric8.kubernetes.api.model.rbac.RoleRefFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.RoleRef,io.fabric8.kubernetes.api.model.rbac.RoleRefBuilder>{
  public RoleRefBuilder() {
    this(false);
  }
  public RoleRefBuilder(java.lang.Boolean validationEnabled) {
    this(new RoleRef(), validationEnabled);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent) {
    this(fluent, false);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RoleRef(), validationEnabled);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleRef instance) {
    this(fluent, instance, false);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleRef instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRef instance) {
    this(instance,false);
  }
  public RoleRefBuilder(io.fabric8.kubernetes.api.model.rbac.RoleRef instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.rbac.RoleRefFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.rbac.RoleRef build() {
    RoleRef buildable = new RoleRef(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RoleRefBuilder that = (RoleRefBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}