package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RoleBindingBuilder extends io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl<io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.RoleBinding,io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder> {

    io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public RoleBindingBuilder() {
        this(true);
    }

    public RoleBindingBuilder(java.lang.Boolean validationEnabled) {
        this(new RoleBinding(), validationEnabled);
    }

    public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent) {
        this(fluent, true);
    }

    public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new RoleBinding(), validationEnabled);
    }

    public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBinding instance) {
        this(fluent, instance, true);
    }

    public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.RoleBinding instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withRoleRef(instance.getRoleRef()); 
        fluent.withSubjects(instance.getSubjects()); 
        this.validationEnabled = validationEnabled; 
    }

    public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBinding instance) {
        this(instance,true);
    }

    public RoleBindingBuilder(io.fabric8.kubernetes.api.model.rbac.RoleBinding instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRoleRef(instance.getRoleRef()); 
        this.withSubjects(instance.getSubjects()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.rbac.RoleBinding build() {
        RoleBinding buildable = new RoleBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RoleBindingBuilder that = (RoleBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
