package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyRuleBuilder extends PolicyRuleFluentImpl<PolicyRuleBuilder> implements VisitableBuilder<PolicyRule,PolicyRuleBuilder>{
  public PolicyRuleBuilder() {
    this(false);
  }
  public PolicyRuleBuilder(Boolean validationEnabled) {
    this(new PolicyRule(), validationEnabled);
  }
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyRule(), validationEnabled);
  }
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,PolicyRule instance) {
    this(fluent, instance, false);
  }
  public PolicyRuleBuilder(PolicyRuleFluent<?> fluent,PolicyRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiGroups(instance.getApiGroups());
      fluent.withNonResourceURLs(instance.getNonResourceURLs());
      fluent.withResourceNames(instance.getResourceNames());
      fluent.withResources(instance.getResources());
      fluent.withVerbs(instance.getVerbs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PolicyRuleBuilder(PolicyRule instance) {
    this(instance,false);
  }
  public PolicyRuleBuilder(PolicyRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withNonResourceURLs(instance.getNonResourceURLs());
      this.withResourceNames(instance.getResourceNames());
      this.withResources(instance.getResources());
      this.withVerbs(instance.getVerbs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PolicyRuleFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyRule build() {
    PolicyRule buildable = new PolicyRule(fluent.getApiGroups(),fluent.getNonResourceURLs(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}