package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RoleBindingFluentImpl<A extends RoleBindingFluent<A>> extends BaseFluent<A> implements RoleBindingFluent<A>{
  public RoleBindingFluentImpl() {
  }
  public RoleBindingFluentImpl(RoleBinding instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRoleRef(instance.getRoleRef());
      this.withSubjects(instance.getSubjects());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private RoleRefBuilder roleRef;
  private ArrayList<SubjectBuilder> subjects = new ArrayList<SubjectBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public RoleBindingFluentImpl.MetadataNested<A> withNewMetadata() {
    return new RoleBindingFluentImpl.MetadataNestedImpl();
  }
  public RoleBindingFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new RoleBindingFluentImpl.MetadataNestedImpl(item);
  }
  public RoleBindingFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public RoleBindingFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public RoleBindingFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRoleRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public RoleRef getRoleRef() {
    return this.roleRef!=null ?this.roleRef.build():null;
  }
  public RoleRef buildRoleRef() {
    return this.roleRef!=null ?this.roleRef.build():null;
  }
  public A withRoleRef(RoleRef roleRef) {
    _visitables.get("roleRef").remove(this.roleRef);
    if (roleRef!=null){ this.roleRef= new RoleRefBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} else { this.roleRef = null; _visitables.get("roleRef").remove(this.roleRef); } return (A) this;
  }
  public Boolean hasRoleRef() {
    return this.roleRef != null;
  }
  public A withNewRoleRef(String apiGroup,String kind,String name) {
    return (A)withRoleRef(new RoleRef(apiGroup, kind, name));
  }
  public RoleBindingFluentImpl.RoleRefNested<A> withNewRoleRef() {
    return new RoleBindingFluentImpl.RoleRefNestedImpl();
  }
  public RoleBindingFluentImpl.RoleRefNested<A> withNewRoleRefLike(RoleRef item) {
    return new RoleBindingFluentImpl.RoleRefNestedImpl(item);
  }
  public RoleBindingFluentImpl.RoleRefNested<A> editRoleRef() {
    return withNewRoleRefLike(getRoleRef());
  }
  public RoleBindingFluentImpl.RoleRefNested<A> editOrNewRoleRef() {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new RoleRefBuilder().build());
  }
  public RoleBindingFluentImpl.RoleRefNested<A> editOrNewRoleRefLike(RoleRef item) {
    return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
  }
  public A addToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").add(index, builder); subjects.add(index, builder);}
    return (A)this;
  }
  public A setToSubjects(int index,Subject item) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    SubjectBuilder builder = new SubjectBuilder(item);
    if (index < 0 || index >= subjects.size()) { _visitables.get("subjects").add(builder); subjects.add(builder); } else { _visitables.get("subjects").set(index, builder); subjects.set(index, builder);}
    return (A)this;
  }
  public A addToSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A addAllToSubjects(Collection<Subject> items) {
    if (this.subjects == null) {this.subjects = new ArrayList<SubjectBuilder>();}
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubjects(Collection<Subject> items) {
    for (Subject item : items) {SubjectBuilder builder = new SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
    if (subjects == null) return (A) this;
    final Iterator<SubjectBuilder> each = subjects.iterator();
    final List visitables = _visitables.get("subjects");
    while (each.hasNext()) {
      SubjectBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubjects instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Subject> getSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public List<Subject> buildSubjects() {
    return subjects != null ? build(subjects) : null;
  }
  public Subject buildSubject(int index) {
    return this.subjects.get(index).build();
  }
  public Subject buildFirstSubject() {
    return this.subjects.get(0).build();
  }
  public Subject buildLastSubject() {
    return this.subjects.get(subjects.size() - 1).build();
  }
  public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
    for (SubjectBuilder item: subjects) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
    for (SubjectBuilder item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(List<Subject> subjects) {
    if (this.subjects != null) { _visitables.get("subjects").clear();}
    if (subjects != null) {this.subjects = new ArrayList(); for (Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear(); _visitables.remove("subjects"); }
    if (subjects != null) {for (Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public A addNewSubject(String apiGroup,String kind,String name,String namespace) {
    return (A)addToSubjects(new Subject(apiGroup, kind, name, namespace));
  }
  public RoleBindingFluentImpl.SubjectsNested<A> addNewSubject() {
    return new RoleBindingFluentImpl.SubjectsNestedImpl();
  }
  public RoleBindingFluentImpl.SubjectsNested<A> addNewSubjectLike(Subject item) {
    return new RoleBindingFluentImpl.SubjectsNestedImpl(-1, item);
  }
  public RoleBindingFluentImpl.SubjectsNested<A> setNewSubjectLike(int index,Subject item) {
    return new RoleBindingFluentImpl.SubjectsNestedImpl(index, item);
  }
  public RoleBindingFluentImpl.SubjectsNested<A> editSubject(int index) {
    if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public RoleBindingFluentImpl.SubjectsNested<A> editFirstSubject() {
    if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
    return setNewSubjectLike(0, buildSubject(0));
  }
  public RoleBindingFluentImpl.SubjectsNested<A> editLastSubject() {
    int index = subjects.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public RoleBindingFluentImpl.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subjects.size();i++) { 
    if (predicate.test(subjects.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
    return setNewSubjectLike(index, buildSubject(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RoleBindingFluentImpl that = (RoleBindingFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(roleRef, that.roleRef)) return false;

    if (!java.util.Objects.equals(subjects, that.subjects)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  roleRef,  subjects,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (roleRef != null) { sb.append("roleRef:"); sb.append(roleRef + ","); }
    if (subjects != null) { sb.append("subjects:"); sb.append(subjects + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<RoleBindingFluentImpl.MetadataNested<N>> implements RoleBindingFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) RoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class RoleRefNestedImpl<N> extends RoleRefFluentImpl<RoleBindingFluentImpl.RoleRefNested<N>> implements RoleBindingFluentImpl.RoleRefNested<N>,Nested<N>{
    RoleRefNestedImpl(RoleRef item) {
      this.builder = new RoleRefBuilder(this, item);
    }
    RoleRefNestedImpl() {
      this.builder = new RoleRefBuilder(this);
    }
    RoleRefBuilder builder;
    public N and() {
      return (N) RoleBindingFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef() {
      return and();
    }
    
  }
  class SubjectsNestedImpl<N> extends SubjectFluentImpl<RoleBindingFluentImpl.SubjectsNested<N>> implements RoleBindingFluentImpl.SubjectsNested<N>,Nested<N>{
    SubjectsNestedImpl(int index,Subject item) {
      this.index = index;
      this.builder = new SubjectBuilder(this, item);
    }
    SubjectsNestedImpl() {
      this.index = -1;
      this.builder = new SubjectBuilder(this);
    }
    SubjectBuilder builder;
    int index;
    public N and() {
      return (N) RoleBindingFluentImpl.this.setToSubjects(index,builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}